/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.home;

import com.atlassian.stash.internal.ApplicationConstants;
import com.google.common.io.Closeables;
import jakarta.annotation.Nonnull;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HomeLock
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(HomeLock.class);
    private final boolean shared;
    private final Path lockFile;
    private volatile FileChannel lockChannel;

    public HomeLock(@Nonnull Path homeDir, boolean shared) {
        this.shared = shared;
        this.lockFile = Objects.requireNonNull(homeDir, "homeDir").resolve(".lock");
    }

    @Override
    public void close() {
        if (this.lockChannel == null) {
            return;
        }
        try {
            this.lockChannel.close();
        }
        catch (IOException e) {
            log.warn("Failed to close channel for file {}", (Object)this.lockFile, (Object)e);
        }
        if (!this.shared) {
            try {
                Files.delete(this.lockFile);
            }
            catch (IOException e) {
                this.lockFile.toFile().deleteOnExit();
                log.error("Failed to delete lock file {}; it may have to be deleted manually before {} can be started again", new Object[]{this.lockFile, ApplicationConstants.PRODUCT_NAME, e});
            }
        }
        this.lockChannel = null;
    }

    public boolean isShared() {
        return this.shared;
    }

    public boolean lock() throws IOException {
        if (this.lockChannel != null) {
            throw new OverlappingFileLockException();
        }
        if (this.isLockable()) {
            return this.acquireLock();
        }
        throw new FileNotFoundException("Failed to create lock file " + String.valueOf(this.lockFile.toAbsolutePath()));
    }

    public String toString() {
        return this.lockFile.toAbsolutePath().toString();
    }

    private boolean acquireLock() throws IOException {
        FileChannel fileChannel = FileChannel.open(this.lockFile, HomeLock.fileOptionsFor(this.shared), new FileAttribute[0]);
        try {
            FileLock lock = fileChannel.tryLock(0L, Long.MAX_VALUE, this.shared);
            if (lock == null) {
                return false;
            }
            this.lockChannel = fileChannel;
        }
        catch (IOException | RuntimeException e) {
            Closeables.close((Closeable)this.lockChannel, (boolean)true);
            throw e;
        }
        if (!this.shared) {
            String whoAmI = ManagementFactory.getRuntimeMXBean().getName();
            try {
                fileChannel.write(ByteBuffer.wrap((whoAmI + "\n").getBytes()));
            }
            catch (IOException e) {
                log.warn("Failed to write process information into the lock file", (Throwable)e);
            }
        }
        return true;
    }

    private static Set<StandardOpenOption> fileOptionsFor(boolean shared) {
        EnumSet<StandardOpenOption> fileOptions = EnumSet.of(StandardOpenOption.READ);
        if (!shared) {
            fileOptions.add(StandardOpenOption.WRITE);
        }
        return fileOptions;
    }

    private boolean isLockable() {
        if (Files.isRegularFile(this.lockFile, new LinkOption[0])) {
            return true;
        }
        try {
            Files.createFile(this.lockFile, new FileAttribute[0]);
            return true;
        }
        catch (FileAlreadyExistsException e) {
            return true;
        }
        catch (IOException e) {
            return Files.isRegularFile(this.lockFile, new LinkOption[0]);
        }
    }
}

