/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.home;

import com.atlassian.bitbucket.util.PropertiesUtils;
import com.atlassian.bitbucket.util.Version;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class HomeProperties {
    private static final String PROP_BUILD_VERSION = "home.build";
    private static final String PROP_LAYOUT_VERSION = "home.layout";
    private final Version build;
    private final Version layout;

    HomeProperties(@Nonnull Version build, @Nonnull Version layout) {
        this.build = Objects.requireNonNull(build, "build");
        this.layout = Objects.requireNonNull(layout, "layout");
    }

    private HomeProperties(@Nonnull Properties properties) {
        Objects.requireNonNull(properties, "properties");
        this.build = HomeProperties.parseVersion(properties.getProperty(PROP_BUILD_VERSION));
        this.layout = HomeProperties.parseVersion(properties.getProperty(PROP_LAYOUT_VERSION));
    }

    @Nonnull
    public Version getBuild() {
        return this.build;
    }

    @Nonnull
    public Version getLayout() {
        return this.layout;
    }

    @Nullable
    static HomeProperties load(@Nonnull Path path) throws IOException {
        return PropertiesUtils.loadIfPresent((Path)path).map(HomeProperties::new).orElse(null);
    }

    void store(@Nonnull Path path) throws IOException {
        Objects.requireNonNull(path, "path");
        Properties properties = new Properties();
        properties.setProperty(PROP_BUILD_VERSION, this.build.toString());
        properties.setProperty(PROP_LAYOUT_VERSION, this.layout.toString());
        PropertiesUtils.store((Properties)properties, (Path)path);
    }

    private static Version parseVersion(String value) {
        return StringUtils.isBlank((CharSequence)value) ? new Version(new Integer[]{0}) : new Version(value);
    }
}

