/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.home;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.util.PropertiesUtils;
import com.atlassian.bitbucket.util.Version;
import com.atlassian.stash.internal.HomeLayout;
import com.atlassian.stash.internal.home.HomeProperties;
import com.atlassian.stash.internal.home.HomeValidationFailedException;
import com.atlassian.stash.internal.home.IncompatibleHomeDirectoryException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HomeValidator {
    static final String PATH_LEGACY_VERSION = ".version";
    static final String PATH_PROPERTIES = "home.properties";
    static final String PROP_LEGACY_BUILD_VERSION = "stash.home.build.version";
    private static final Logger log = LoggerFactory.getLogger(HomeValidator.class);
    private final Version build;
    private final Path homeDir;

    public HomeValidator(Path homeDir, Version build) {
        this.build = build;
        this.homeDir = homeDir;
    }

    public void validate() {
        Version cachedVersion = this.maybeUpdateLegacyVersion();
        try {
            boolean update;
            HomeProperties properties = HomeProperties.load(this.homeDir.resolve(PATH_PROPERTIES));
            if (properties == null) {
                if (cachedVersion != null) {
                    log.info("Upgrading {} from {} to {} is a backward-incompatible upgrade. It will not be possible to downgrade to an older version without restoring from a backup", new Object[]{Product.NAME, cachedVersion, this.build});
                }
                update = true;
            } else {
                update = this.validateLayout(properties);
            }
            if (update) {
                new HomeProperties(this.build, HomeLayout.VERSION).store(this.homeDir.resolve(PATH_PROPERTIES));
            }
        }
        catch (IOException e) {
            throw new HomeValidationFailedException("The home directory cannot be validated for use by " + Product.NAME + " " + String.valueOf(this.build), e);
        }
    }

    private static VersionUpdate detectUpdate(Version now, Version then) {
        int majorThen;
        int majorNow = now.getMajor();
        if (majorNow > (majorThen = then.getMajor())) {
            return VersionUpdate.MAJOR_UPGRADE;
        }
        if (majorNow < majorThen) {
            return VersionUpdate.MAJOR_DOWNGRADE;
        }
        int comparison = now.compareTo(then);
        if (comparison == 0) {
            return VersionUpdate.NONE;
        }
        return comparison > 0 ? VersionUpdate.MINOR_UPGRADE : VersionUpdate.MINOR_DOWNGRADE;
    }

    private boolean validateLayout(HomeProperties properties) {
        VersionUpdate update = HomeValidator.detectUpdate(HomeLayout.VERSION, properties.getLayout());
        if (update == VersionUpdate.MAJOR_DOWNGRADE) {
            log.warn("Downgrading {} from {} to {} requires restoring from a backup taken prior to the upgrade. The home directory layout has been updated from {} to {} and is no longer compatible", new Object[]{Product.NAME, properties.getBuild(), this.build, HomeLayout.VERSION, properties.getLayout()});
            throw new IncompatibleHomeDirectoryException("The home directory has been updated by " + Product.NAME + " " + String.valueOf(properties.getBuild()) + " and is no longer compatible with " + String.valueOf(this.build));
        }
        if (update == VersionUpdate.MAJOR_UPGRADE) {
            log.info("Upgrading {} from {} to {} is a backward-incompatible upgrade. The home directory will be upgraded with a new layout ({} -> {}). It will not be possible to downgrade to an older version without restoring from a backup", new Object[]{Product.NAME, properties.getBuild(), this.build, properties.getLayout(), HomeLayout.VERSION});
        } else if (update == VersionUpdate.MINOR_UPGRADE) {
            log.info("Upgrading {} from {} to {} will upgrade the home directory from {} to {}", new Object[]{Product.NAME, properties.getBuild(), this.build, properties.getLayout(), HomeLayout.VERSION});
        } else if (update == VersionUpdate.MINOR_DOWNGRADE) {
            log.warn("Downgrading {} from {} to {} will not roll back the home directory layout from {} to {}", new Object[]{Product.NAME, properties.getBuild(), this.build, properties.getLayout(), HomeLayout.VERSION});
        } else {
            update = HomeValidator.detectUpdate(this.build, properties.getBuild());
            if (update != VersionUpdate.NONE) {
                if (update.isUpgrade()) {
                    log.info("Upgrading {} from {} to {}", new Object[]{Product.NAME, properties.getBuild(), this.build});
                } else {
                    log.warn("Downgrading {} from {} to {}", new Object[]{Product.NAME, properties.getBuild(), this.build});
                }
            }
        }
        return update.isUpgrade();
    }

    private Version maybeUpdateLegacyVersion() {
        Properties properties;
        Version legacyVersion = null;
        try {
            properties = PropertiesUtils.load((Path)this.homeDir.resolve(PATH_LEGACY_VERSION));
            String version = properties.getProperty(PROP_LEGACY_BUILD_VERSION);
            if (version != null && this.build.compareTo(legacyVersion = new Version(version)) < 1) {
                return legacyVersion;
            }
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            log.debug("{} does not exist; it will be created", (Object)PATH_LEGACY_VERSION);
        }
        catch (IOException e) {
            log.warn("Failed to read {}; it will be recreated", (Object)PATH_LEGACY_VERSION, (Object)e);
        }
        try {
            properties = new Properties();
            properties.setProperty(PROP_LEGACY_BUILD_VERSION, this.build.toString());
            PropertiesUtils.store((Properties)properties, (Path)this.homeDir.resolve(PATH_LEGACY_VERSION));
        }
        catch (IOException e) {
            log.warn("Failed to write {}", (Object)PATH_LEGACY_VERSION, (Object)e);
        }
        return legacyVersion;
    }

    private static enum VersionUpdate {
        MAJOR_DOWNGRADE(false),
        MAJOR_UPGRADE(true),
        MINOR_DOWNGRADE(false),
        MINOR_UPGRADE(true),
        NONE(false);

        private final boolean upgrade;

        private VersionUpdate(boolean upgrade) {
            this.upgrade = upgrade;
        }

        boolean isUpgrade() {
            return this.upgrade;
        }
    }
}

