/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.i18n;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collection;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class ClasspathI18nMessageSource
extends ResourceBundleMessageSource {
    public ClasspathI18nMessageSource() throws IOException {
        PathMatchingResourcePatternResolver patternResolver = new PathMatchingResourcePatternResolver();
        ImmutableList resources = ImmutableList.builder().add((Object[])patternResolver.getResources("classpath*:/i18n/stash-*.properties")).add((Object[])patternResolver.getResources("classpath*:/i18n/bitbucket-*.properties")).build();
        Collection baseNames = Collections2.filter((Collection)Collections2.transform((Collection)resources, (Function)new Function<Resource, String>(this){

            public String apply(Resource resource) {
                String name = resource.getFilename();
                return "i18n/" + name.substring(0, name.length() - ".properties".length());
            }
        }), (Predicate)Predicates.notNull());
        if (!baseNames.isEmpty()) {
            this.setBasenames(baseNames.toArray(new String[baseNames.size()]));
        }
    }
}

