/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.johnson;

import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.List;
import java.util.regex.Pattern;

public class JohnsonUtils {
    public static final String EVENT_TYPE_NODE_PASSIVATED = "node-passivated";
    public static final String LEVEL_MAINTENANCE = "maintenance";
    public static final String LEVEL_SYSTEM_MAINTENANCE = "system-maintenance";
    private static final List<String> EVENT_LEVELS = ImmutableList.of((Object)"system-maintenance", (Object)"maintenance", (Object)"warning", (Object)"error", (Object)"fatal");
    private static final Pattern PREPENDING_SLASHES = Pattern.compile("^/+");

    private JohnsonUtils() {
        throw new UnsupportedOperationException();
    }

    public static String getRedirectUrl(HttpServletRequest request, String fallbackUrl) throws UnsupportedEncodingException {
        String nextUrl = request.getParameter("next");
        if (nextUrl == null) {
            nextUrl = fallbackUrl;
        }
        URI url = URI.create(URLDecoder.decode(nextUrl, "UTF-8"));
        Object redirectUrl = url.getPath();
        if (url.getQuery() != null && !url.getQuery().isEmpty()) {
            redirectUrl = (String)redirectUrl + "?" + url.getQuery();
        }
        redirectUrl = PREPENDING_SLASHES.matcher((CharSequence)redirectUrl).replaceFirst("");
        return String.format("/%s", redirectUrl);
    }

    @Nullable
    public static String findHighestEventLevel(@Nonnull JohnsonEventContainer eventContainer) {
        int index = JohnsonUtils.findHighestEventLevelIndex(eventContainer);
        return index == -1 ? null : EVENT_LEVELS.get(index);
    }

    public static boolean isLevelAtLeast(@Nonnull String level, @Nonnull String minimumLevel) {
        int index = EVENT_LEVELS.indexOf(level);
        Preconditions.checkArgument((index != -1 ? 1 : 0) != 0, (String)"Invalid level %s", (Object)level);
        int minimumIndex = EVENT_LEVELS.indexOf(minimumLevel);
        Preconditions.checkArgument((minimumIndex != -1 ? 1 : 0) != 0, (String)"Invalid minimumLevel %s", (int)minimumIndex);
        return minimumIndex <= index;
    }

    public static boolean isLevelAtMost(@Nonnull String level, @Nonnull String maximumLevel) {
        int index = EVENT_LEVELS.indexOf(level);
        Preconditions.checkArgument((index != -1 ? 1 : 0) != 0, (String)"Invalid level %s", (Object)level);
        int maximumIndex = EVENT_LEVELS.indexOf(maximumLevel);
        Preconditions.checkArgument((maximumIndex != -1 ? 1 : 0) != 0, (String)"Invalid maximumLevel %s", (Object)maximumLevel);
        return maximumIndex >= index;
    }

    private static int findHighestEventLevelIndex(JohnsonEventContainer eventContainer) {
        int i = -1;
        for (Event event : eventContainer.getEvents()) {
            int x = EVENT_LEVELS.indexOf(event.getLevel().getLevel());
            if (x <= i) continue;
            i = x;
        }
        return i;
    }
}

