/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.logback;

import ch.qos.logback.classic.Level;
import org.slf4j.Logger;

public enum EnhancedLevel {
    ALL(Level.ALL),
    TRACE(Level.TRACE){

        @Override
        public void log(Logger logger, String message, Object ... parameters) {
            logger.trace(message, parameters);
        }
    }
    ,
    DEBUG(Level.DEBUG),
    INFO(Level.INFO){

        @Override
        public void log(Logger logger, String message, Object ... parameters) {
            logger.info(message, parameters);
        }
    }
    ,
    WARN(Level.WARN){

        @Override
        public void log(Logger logger, String message, Object ... parameters) {
            logger.warn(message, parameters);
        }
    }
    ,
    ERROR(Level.ERROR){

        @Override
        public void log(Logger logger, String message, Object ... parameters) {
            logger.error(message, parameters);
        }
    }
    ,
    OFF(Level.OFF){

        @Override
        public void log(Logger logger, String message, Object ... parameters) {
        }
    };

    private final Level level;

    private EnhancedLevel(Level level) {
        this.level = level;
    }

    public Level getLevel() {
        return this.level;
    }

    public void log(Logger logger, String message, Object ... parameters) {
        logger.debug(message, parameters);
    }

    public static EnhancedLevel fromLevel(Level level) {
        for (EnhancedLevel value : EnhancedLevel.values()) {
            if (value.getLevel() != level) continue;
            return value;
        }
        return OFF;
    }
}

