/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.spi.FilterReply;
import java.util.Locale;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class KnownMessageLevelAdjustingFilter
extends TurboFilter {
    static final Marker FILTERED = MarkerFactory.getDetachedMarker((String)"bb.filtered");
    private static final String BUILD_STATUS_UQ = "uq_bb_build_status_rck";
    private static final String DEPLOYMENTS_UQ = "uq_bb_dep_ri_ci_ek_dk_dn";
    private static final String MESH_REPOSITORY_REPLICA_PK = "pk_bb_mesh_repo_replica";

    public FilterReply decide(Marker marker, Logger logger, Level level, String format, Object[] params, Throwable t) {
        String lower;
        if (FILTERED.equals((Object)marker)) {
            return FilterReply.NEUTRAL;
        }
        if (logger == null || format == null || level != Level.ERROR) {
            return FilterReply.NEUTRAL;
        }
        String name = logger.getName();
        if (("org.hibernate.engine.jdbc.spi.SqlExceptionHelper".equals(name) || "org.hibernate.engine.jdbc.batch.internal.BatchingBatch".equals(name)) && (lower = format.toLowerCase(Locale.ROOT)).contains("violat") && (lower.contains(BUILD_STATUS_UQ) || lower.contains(DEPLOYMENTS_UQ) || lower.contains(MESH_REPOSITORY_REPLICA_PK))) {
            logger.debug(FILTERED, format, (Object)params, (Object)t);
            return FilterReply.DENY;
        }
        return FilterReply.NEUTRAL;
    }
}

