/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import com.atlassian.stash.internal.logback.EnhancedLevel;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogbackUtils {
    private LogbackUtils() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " is not intended to be instantiated");
    }

    @Nonnull
    public static Level getEffectiveLevel(@Nonnull String loggerName) {
        return LogbackUtils.getLogger(loggerName).getEffectiveLevel();
    }

    @Nonnull
    public static LoggerContext getLoggerContext() {
        return (LoggerContext)LoggerFactory.getILoggerFactory();
    }

    @Nonnull
    public static ch.qos.logback.classic.Logger getLogger(@Nonnull String loggerName) {
        return LogbackUtils.getLoggerContext().getLogger(loggerName);
    }

    @Nonnull
    public static ch.qos.logback.classic.Logger getRootLogger() {
        return LogbackUtils.getLogger("ROOT");
    }

    public static void setLevel(@Nonnull String loggerName, @Nullable String levelName) {
        Level newLevel;
        ch.qos.logback.classic.Logger logger = LogbackUtils.getLogger(loggerName);
        Level effectiveLevel = logger.getEffectiveLevel();
        if (!effectiveLevel.equals(newLevel = LogbackUtils.toLevel(levelName, effectiveLevel))) {
            EnhancedLevel.fromLevel(effectiveLevel).log((Logger)logger, "Switching to log level [{}]", levelName);
            logger.setLevel(newLevel);
        }
    }

    @Nonnull
    public static Level toLevel(@Nullable String levelName) {
        return LogbackUtils.toLevel(levelName, Level.DEBUG);
    }

    public static Level toLevel(@Nullable String levelName, @Nullable Level defaultLevel) {
        if ("false".equals(levelName)) {
            return Level.OFF;
        }
        return Level.toLevel((String)levelName, (Level)defaultLevel);
    }
}

