/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.logback.pattern;

import ch.qos.logback.classic.pattern.ExtendedThrowableProxyConverter;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.CoreConstants;
import com.atlassian.stash.internal.logback.pattern.FilteredThrowableProxy;
import java.sql.SQLException;
import java.util.Arrays;

public class EnhancedThrowableConverter
extends ExtendedThrowableProxyConverter {
    private static final String PROP_FULL_STACK_TRACES = "bitbucket.log.fullStackTraces";
    private final boolean logFullStackTrace = Boolean.parseBoolean(System.getProperty("bitbucket.log.fullStackTraces", "false"));

    protected String throwableProxyToString(IThrowableProxy proxy) {
        StringBuilder buf = new StringBuilder(2048);
        this.appendThrowable(buf, (IThrowableProxy)(this.logFullStackTrace ? proxy : new FilteredThrowableProxy(proxy)), null, 0);
        return buf.toString();
    }

    private void appendCause(StringBuilder buf, IThrowableProxy proxy, int indent) {
        IThrowableProxy cause = proxy.getCause();
        if (cause != null) {
            this.appendThrowable(buf, cause, "Caused by: ", indent);
        }
    }

    private void appendNextException(StringBuilder buf, IThrowableProxy proxy, int indent) {
        SQLException next = this.getNextException(proxy);
        if (next != null) {
            this.appendThrowable(buf, (IThrowableProxy)new ThrowableProxy((Throwable)next), "Next exception: ", indent + 1);
        }
    }

    private void appendSuppressedExceptions(StringBuilder buf, IThrowableProxy proxy, int indent) {
        IThrowableProxy[] suppressed = proxy.getSuppressed();
        if (suppressed != null) {
            Arrays.stream(suppressed).forEach(s -> this.appendThrowable(buf, (IThrowableProxy)s, "Suppressed: ", indent + 1));
        }
    }

    private void appendThrowable(StringBuilder buf, IThrowableProxy proxy, String prefix, int indent) {
        ThrowableProxyUtil.indent((StringBuilder)buf, (int)indent);
        if (prefix != null) {
            buf.append(prefix);
        }
        buf.append(proxy.getClassName()).append(": ").append(proxy.getMessage()).append(CoreConstants.LINE_SEPARATOR);
        this.subjoinSTEPArray(buf, indent + 1, proxy);
        this.appendNextException(buf, proxy, indent);
        this.appendSuppressedExceptions(buf, proxy, indent);
        this.appendCause(buf, proxy, indent);
    }

    private SQLException getNextException(IThrowableProxy proxy) {
        Throwable t = this.unwrapException(proxy);
        if (t instanceof SQLException) {
            return ((SQLException)t).getNextException();
        }
        return null;
    }

    private Throwable unwrapException(IThrowableProxy proxy) {
        if (proxy instanceof FilteredThrowableProxy) {
            return this.unwrapException(((FilteredThrowableProxy)proxy).getThrowableProxy());
        }
        if (proxy instanceof ThrowableProxy) {
            return ((ThrowableProxy)proxy).getThrowable();
        }
        this.addWarn(String.format("Unexpected implementation of %s: %s", IThrowableProxy.class.getSimpleName(), proxy.getClass().getName()));
        return null;
    }
}

