/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.osgi;

import com.atlassian.plugin.osgi.util.OsgiHeaderUtil;
import java.util.Collection;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;

public class BitbucketDmzResolverHook
implements ResolverHook {
    static final String ATTR_WIRING_PACKAGE = "osgi.wiring.package";
    private final Set<String> bundledPluginKeys;
    private final Set<String> dmzPackages;

    public BitbucketDmzResolverHook(Set<String> bundledPluginKeys, Set<String> dmzPackages) {
        this.bundledPluginKeys = bundledPluginKeys;
        this.dmzPackages = dmzPackages;
    }

    public void end() {
    }

    public void filterMatches(BundleRequirement requirement, Collection<BundleCapability> candidates) {
        String pluginKey = OsgiHeaderUtil.getPluginKey((Bundle)requirement.getRevision().getBundle());
        if (!this.bundledPluginKeys.contains(pluginKey)) {
            candidates.removeIf(this::isDmzPackage);
        }
    }

    public void filterResolvable(Collection<BundleRevision> candidates) {
    }

    public void filterSingletonCollisions(BundleCapability singleton, Collection<BundleCapability> collisions) {
    }

    private boolean isDmzPackage(BundleCapability candidate) {
        Object wiringPackageAtt = candidate.getAttributes().get(ATTR_WIRING_PACKAGE);
        if (wiringPackageAtt instanceof String) {
            String wiringPackage = (String)wiringPackageAtt;
            return this.dmzPackages.stream().anyMatch(wiringPackage::startsWith);
        }
        return false;
    }
}

