/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.osgi;

import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.mode.DefaultApplicationMode;
import com.atlassian.stash.internal.osgi.BitbucketDmzResolverHook;
import com.atlassian.stash.internal.plugin.PluginKeys;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.wiring.BundleRevision;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=ResolverHookFactory.class)
@Component
@DefaultApplicationMode
public class BitbucketDmzResolverHookFactory
implements ResolverHookFactory {
    private static final String DMZ_PACKAGES = "osgi-dmz-packages.properties";
    private static final Logger log = LoggerFactory.getLogger(BitbucketDmzResolverHookFactory.class);
    private final Set<String> bundledPluginKeys;
    private final Set<String> dmzPackages;

    @Autowired
    public BitbucketDmzResolverHookFactory(PluginKeys pluginKeys) {
        this.bundledPluginKeys = pluginKeys.getInternalBundled();
        this.dmzPackages = BitbucketDmzResolverHookFactory.loadDmzPackages();
    }

    public ResolverHook begin(Collection<BundleRevision> triggers) {
        return new BitbucketDmzResolverHook(this.bundledPluginKeys, this.dmzPackages);
    }

    @Nonnull
    private static Set<String> loadDmzPackages() {
        Properties properties = new Properties();
        try (InputStream in = BitbucketDmzResolverHookFactory.class.getClassLoader().getResourceAsStream(DMZ_PACKAGES);){
            properties.load(in);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return properties.stringPropertyNames();
    }
}

