/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.plugin.manager.PluginPersistentState;
import com.atlassian.plugin.manager.PluginPersistentStateStore;
import jakarta.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusteredPluginPersistentStateStore
implements PluginPersistentStateStore {
    private static final Logger log = LoggerFactory.getLogger(ClusteredPluginPersistentStateStore.class);
    private static final Object LOCK = new Object();
    private final PluginPersistentStateStore delegate;
    private final ThreadLocal<Boolean> readOnlyState;
    private volatile PluginPersistentState cachedState;

    public ClusteredPluginPersistentStateStore(PluginPersistentStateStore delegate) {
        this.delegate = delegate;
        this.readOnlyState = new ThreadLocal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginPersistentState load() {
        if (this.cachedState == null) {
            Object object = LOCK;
            synchronized (object) {
                if (this.cachedState == null) {
                    this.cachedState = this.loadRaw();
                }
            }
        }
        return this.cachedState;
    }

    public ReadOnlyMarker markReadOnly() {
        return new ReadOnlyMarker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(PluginPersistentState state) {
        Object object = LOCK;
        synchronized (object) {
            if (this.isReadOnly()) {
                log.debug("Ignoring plugin state save request as the current thread is propagating an operation from a different node");
            } else {
                this.delegate.save(state);
            }
            this.cachedState = state;
        }
    }

    @Nonnull
    PluginPersistentState loadRaw() {
        return this.delegate.load();
    }

    private boolean isReadOnly() {
        return Boolean.TRUE.equals(this.readOnlyState.get());
    }

    public class ReadOnlyMarker
    implements AutoCloseable {
        public ReadOnlyMarker() {
            ClusteredPluginPersistentStateStore.this.readOnlyState.set(Boolean.TRUE);
        }

        @Override
        public void close() {
            ClusteredPluginPersistentStateStore.this.readOnlyState.remove();
        }
    }
}

