/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.plugin.PluginRestartState;
import com.atlassian.plugin.manager.PluginEnabledState;
import com.atlassian.plugin.manager.PluginPersistentState;
import com.atlassian.plugin.manager.PluginPersistentStateStore;
import com.atlassian.stash.internal.plugin.DelegatingPluginPersistentState;
import com.atlassian.stash.internal.plugin.PluginKeys;
import com.atlassian.stash.internal.plugin.PluginState;
import com.atlassian.stash.internal.plugin.PluginStateDao;
import java.util.Map;
import java.util.Set;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class DefaultPluginPersistentStateStore
implements PluginPersistentStateStore {
    private final Set<String> obsoletePluginKeys;
    private final PluginStateDao pluginStateDao;

    public DefaultPluginPersistentStateStore(PluginKeys pluginKeys, PluginStateDao pluginStateDao) {
        this.pluginStateDao = pluginStateDao;
        this.obsoletePluginKeys = pluginKeys.getObsolete();
    }

    @Transactional(readOnly=true)
    public PluginPersistentState load() {
        PluginPersistentState.Builder builder = PluginPersistentState.Builder.create();
        builder.addPluginEnabledState(this.loadState());
        return new ObsoleteAwarePluginPersistentState(builder.toState());
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void save(PluginPersistentState state) {
        this.pluginStateDao.clear();
        state.getStatesMap().forEach((name, enabledState) -> this.pluginStateDao.create(new PluginState(name, enabledState.isEnabled().booleanValue(), enabledState.getTimestamp())));
    }

    private Map<String, PluginEnabledState> loadState() {
        return (Map)this.pluginStateDao.findAll().stream().collect(MoreCollectors.toImmutableMap(PluginState::getName, state -> new PluginEnabledState(state.isEnabled(), state.getTimestamp())));
    }

    private class ObsoleteAwarePluginPersistentState
    extends DelegatingPluginPersistentState {
        ObsoleteAwarePluginPersistentState(PluginPersistentState delegate) {
            super(delegate);
        }

        @Override
        public PluginRestartState getPluginRestartState(String pluginKey) {
            if (DefaultPluginPersistentStateStore.this.obsoletePluginKeys.contains(pluginKey)) {
                return PluginRestartState.REMOVE;
            }
            return super.getPluginRestartState(pluginKey);
        }
    }
}

