/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.sal.core.pluginsettings.AbstractStringPluginSettings;
import com.atlassian.stash.internal.plugin.PluginSetting;
import com.atlassian.stash.internal.plugin.PluginSettingDao;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Scope;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.UncategorizedDataAccessException;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;

@Component(value="pluginSettingsPrototype")
@Scope(value="prototype")
public class DefaultPluginSettings
extends AbstractStringPluginSettings {
    private final PluginSettingDao dao;
    private final String namespace;
    private final TransactionTemplate readOnlyTransaction;
    private final TransactionTemplate readWriteTransaction;

    public DefaultPluginSettings(PluginSettingDao dao, String namespace, TransactionTemplate readOnlyTransaction, TransactionTemplate readWriteTransaction) {
        this.dao = dao;
        this.namespace = namespace;
        this.readOnlyTransaction = readOnlyTransaction;
        this.readWriteTransaction = readWriteTransaction;
    }

    protected String getActual(String key) {
        return (String)this.readOnlyTransaction.execute(status -> this.dao.get(this.namespace, key));
    }

    protected void putActual(String key, String val) {
        if (StringUtils.isEmpty((CharSequence)val)) {
            this.removeActual(key);
        } else {
            PluginSetting setting;
            int tries = 1;
            while (true) {
                try {
                    setting = (PluginSetting)this.readWriteTransaction.execute(status -> this.dao.put(this.namespace, key, val));
                }
                catch (DataIntegrityViolationException e) {
                    if (tries >= 5) {
                        throw e;
                    }
                    ++tries;
                    continue;
                }
                break;
            }
            if (TransactionSynchronizationManager.isActualTransactionActive()) {
                this.dao.attach(setting);
            }
        }
    }

    protected void removeActual(String key) {
        try {
            this.doInTransaction(() -> this.dao.remove(this.namespace, key));
        }
        catch (UncategorizedDataAccessException uncategorizedDataAccessException) {
            // empty catch block
        }
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            this.dao.evict(this.namespace, key);
        }
    }

    private void doInTransaction(final Runnable runnable) {
        this.readWriteTransaction.execute((TransactionCallback)new TransactionCallbackWithoutResult(this){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                runnable.run();
            }
        });
    }
}

