/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.stash.internal.plugin.ContextClassLoaderSettingInvocationHandler;
import com.atlassian.stash.internal.plugin.PluginSettingDao;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import jakarta.annotation.Nonnull;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Component(value="pluginSettingsFactory")
@AvailableToPlugins(value=PluginSettingsFactory.class)
public class DefaultPluginSettingsFactory
implements PluginSettingsFactory {
    public static final String GLOBAL_SETTING_NAMESPACE = "bitbucket.global.settings";
    private final ApplicationContext applicationContext;
    private final PluginSettingDao pluginSettingDao;
    private final TransactionTemplate readOnlyTransaction;
    private final TransactionTemplate readWriteTransaction;
    private final LoadingCache<String, PluginSettings> settingsForKey;
    private PluginSettings globalSettings;

    @Autowired
    public DefaultPluginSettingsFactory(ApplicationContext applicationContext, PluginSettingDao pluginSettingDao, PlatformTransactionManager transactionManager) {
        this.applicationContext = applicationContext;
        this.pluginSettingDao = pluginSettingDao;
        this.readOnlyTransaction = new TransactionTemplate(transactionManager, SpringTransactionUtils.definitionFor((int)3, (boolean)true));
        this.readWriteTransaction = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
        this.settingsForKey = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new CacheLoader<String, PluginSettings>(){

            public PluginSettings load(@Nonnull String namespace) throws Exception {
                return (PluginSettings)Proxy.newProxyInstance(PluginSettings.class.getClassLoader(), new Class[]{PluginSettings.class}, (InvocationHandler)new ContextClassLoaderSettingInvocationHandler(DefaultPluginSettingsFactory.this.applicationContext.getBean("pluginSettingsPrototype", new Object[]{DefaultPluginSettingsFactory.this.pluginSettingDao, namespace, DefaultPluginSettingsFactory.this.readOnlyTransaction, DefaultPluginSettingsFactory.this.readWriteTransaction})));
            }
        });
    }

    public PluginSettings createGlobalSettings() {
        if (this.globalSettings == null) {
            this.globalSettings = (PluginSettings)this.settingsForKey.apply((Object)GLOBAL_SETTING_NAMESPACE);
        }
        return this.globalSettings;
    }

    public PluginSettings createSettingsForKey(String key) {
        try {
            return (PluginSettings)this.settingsForKey.getUnchecked((Object)key);
        }
        catch (UncheckedExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }
}

