/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.bitbucket.util.Operation;
import com.atlassian.plugin.servlet.AbstractFileServerServlet;
import com.atlassian.plugin.servlet.DownloadStrategy;
import com.atlassian.stash.internal.locale.LocaleUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.HttpRequestHandler;

@Component(value="fileServerServlet")
public class FileServerServlet
extends AbstractFileServerServlet
implements HttpRequestHandler {
    private final List<DownloadStrategy> downloadStrategies;

    @Autowired
    public FileServerServlet(DownloadStrategy[] downloadStrategies) {
        Preconditions.checkArgument((Objects.requireNonNull(downloadStrategies, "downloadStrategies").length > 0 ? 1 : 0) != 0, (Object)"At least one DownloadStrategy must be available");
        this.downloadStrategies = ImmutableList.copyOf((Object[])downloadStrategies);
    }

    public void handleRequest(final HttpServletRequest request, final HttpServletResponse response) throws IOException {
        LocaleUtils.withoutLocale(new Operation<Object, IOException>(){

            public Object perform() throws IOException {
                FileServerServlet.this.doGet(request, response);
                return null;
            }
        });
    }

    protected List<DownloadStrategy> getDownloadStrategies() {
        return this.downloadStrategies;
    }
}

