/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.bitbucket.scm.BaseWeightedModuleDescriptor;
import com.atlassian.bitbucket.ui.ContextualFormFragment;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.util.validation.ValidationException;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.web.descriptors.ConditionElementParser;
import com.atlassian.stash.internal.plugin.StashConditionFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;

public class FormFragmentModuleDescriptor
extends BaseWeightedModuleDescriptor<ContextualFormFragment> {
    public static final String XML_ELEMENT_NAME = "form-fragment";
    private final ConditionElementParser conditionElementParser;
    private Condition condition;
    private Element element;
    private String location;

    public FormFragmentModuleDescriptor(ModuleFactory moduleFactory, StashConditionFactory stashConditionFactory) {
        super(moduleFactory, 100);
        this.conditionElementParser = new ConditionElementParser((ConditionElementParser.ConditionFactory)stashConditionFactory);
    }

    public void disabled() {
        this.condition = null;
        super.disabled();
    }

    public void enabled() {
        super.enabled();
        this.condition = this.conditionElementParser.makeConditions(this.plugin, this.element, 1);
    }

    @Nullable
    public Condition getCondition() {
        return this.condition;
    }

    @Nonnull
    public String getLocation() {
        return this.location;
    }

    @Nonnull
    public ContextualFormFragment getModule() {
        return (ContextualFormFragment)this.moduleFactory.createModule(this.moduleClassName, (ModuleDescriptor)this);
    }

    public void init(@Nonnull Plugin plugin, @Nonnull Element element) throws PluginParseException {
        super.init(plugin, element);
        this.element = element;
        this.location = element.attributeValue("location");
    }

    protected void validate(Element element) {
        super.validate(element);
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (element.attributeValue("class") == null) {
            validationErrors.add("The class is required");
        }
        if (element.attributeValue("location") == null) {
            validationErrors.add("The location is required");
        }
        if (!validationErrors.isEmpty()) {
            throw new ValidationException(validationErrors);
        }
    }
}

