/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.util.validation.ValidationException;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Locale;

public class LanguageModuleDescriptor
extends AbstractModuleDescriptor<Locale> {
    public static final String XML_ELEMENT_NAME = "language";
    private volatile Locale locale;

    public LanguageModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public Locale getModule() {
        return this.locale;
    }

    public void init(@Nonnull Plugin plugin, @Nonnull Element element) throws PluginParseException {
        super.init(plugin, element);
        String language = element.attributeValue(XML_ELEMENT_NAME);
        String country = element.attributeValue("country");
        String variant = element.attributeValue("variant");
        this.locale = new Locale(language, (String)MoreObjects.firstNonNull((Object)country, (Object)""), (String)MoreObjects.firstNonNull((Object)variant, (Object)""));
    }

    protected void validate(Element element) {
        super.validate(element);
        if (element.attributeValue(XML_ELEMENT_NAME) == null) {
            throw new ValidationException(List.of("The language attribute is required"));
        }
    }
}

