/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.bitbucket.dmz.notification.NotificationHandler;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.util.validation.ValidationException;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;

public class NotificationHandlerModuleDescriptor
extends AbstractModuleDescriptor<NotificationHandler> {
    public static final String XML_ELEMENT_NAME = "notification-handler";
    private String notificationClass;

    public NotificationHandlerModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    protected void validate(Element element) {
        super.validate(element);
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (element.attributeValue("class") == null) {
            validationErrors.add("The notification handler class is required");
        }
        if (element.attributeValue("notification") == null) {
            validationErrors.add("The notification class is required");
        }
        if (!validationErrors.isEmpty()) {
            throw new ValidationException(validationErrors);
        }
    }

    public void init(@Nonnull Plugin plugin, @Nonnull Element element) throws PluginParseException {
        super.init(plugin, element);
        this.notificationClass = element.attributeValue("notification", "");
    }

    public NotificationHandler getModule() {
        return (NotificationHandler)this.moduleFactory.createModule(this.moduleClassName, (ModuleDescriptor)this);
    }

    public String getNotificationClass() {
        return this.notificationClass;
    }
}

