/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.repositories.FilePluginInstaller;
import com.atlassian.stash.internal.plugin.PluginKeys;
import java.io.File;
import java.util.Set;

public class ObsoleteAwareFilePluginInstaller
extends FilePluginInstaller {
    private final Set<String> obsoletePluginKeys;

    public ObsoleteAwareFilePluginInstaller(File directory, PluginKeys pluginKeys) {
        super(directory);
        this.obsoletePluginKeys = pluginKeys.getObsolete();
    }

    public void installPlugin(String key, PluginArtifact pluginArtifact) {
        if (this.obsoletePluginKeys.contains(key)) {
            throw new PluginParseException(key + " is obsolete and cannot be installed");
        }
        super.installPlugin(key, pluginArtifact);
    }
}

