/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.stash.internal.plugin.InternalHostContainer;
import com.atlassian.stash.internal.plugin.OsgiSafeProxyProvider;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import jakarta.annotation.Nonnull;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.Aware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.CglibSubclassingInstantiationStrategy;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.InstantiationStrategy;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component(value="hostContainer")
public class OsgiSafeHostContainer
implements InternalHostContainer {
    private final ApplicationContext applicationContext;
    private final DefaultListableBeanFactory beanFactory;
    private final OsgiSafeProxyProvider proxyProvider;

    @Autowired
    public OsgiSafeHostContainer(ApplicationContext applicationContext, OsgiSafeProxyProvider proxyProvider) {
        this.applicationContext = applicationContext;
        this.proxyProvider = proxyProvider;
        this.beanFactory = new DefaultListableBeanFactory((BeanFactory)applicationContext.getAutowireCapableBeanFactory());
        this.beanFactory.addBeanPostProcessor((BeanPostProcessor)new EnvironmentAwarePostProcessor(applicationContext.getEnvironment()));
        this.beanFactory.setInstantiationStrategy((InstantiationStrategy)new ProxyingInstantiationStrategy(proxyProvider));
    }

    public <T> T create(Class<T> moduleClass) throws IllegalArgumentException {
        return (T)this.beanFactory.createBean(moduleClass, 3, false);
    }

    @Override
    @Nonnull
    public <T> Map<String, T> getComponentsOfType(final @Nonnull Class<T> tClass) {
        return Maps.transformValues((Map)this.applicationContext.getBeansOfType(tClass), (Function)new Function<T, T>(){

            public T apply(T value) {
                return tClass.cast(OsgiSafeHostContainer.this.proxyProvider.proxy(value, tClass));
            }
        });
    }

    private static class EnvironmentAwarePostProcessor
    implements BeanPostProcessor {
        private final Environment environment;

        public EnvironmentAwarePostProcessor(Environment environment) {
            this.environment = environment;
        }

        public Object postProcessBeforeInitialization(Object bean, String s) throws BeansException {
            if (bean instanceof Aware && bean instanceof EnvironmentAware) {
                ((EnvironmentAware)bean).setEnvironment(this.environment);
            }
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String s) throws BeansException {
            return bean;
        }
    }

    private static class ProxyingInstantiationStrategy
    extends CglibSubclassingInstantiationStrategy {
        private final OsgiSafeProxyProvider proxyFactory;

        private ProxyingInstantiationStrategy(OsgiSafeProxyProvider proxyFactory) {
            this.proxyFactory = proxyFactory;
        }

        public Object instantiate(RootBeanDefinition beanDefinition, String beanName, BeanFactory owner, Constructor<?> ctor, Object[] args) {
            return super.instantiate(beanDefinition, beanName, owner, ctor, this.proxyFactory.proxy(args, ctor.getParameterTypes()));
        }

        public Object instantiate(RootBeanDefinition beanDefinition, String beanName, BeanFactory owner, Object factoryBean, Method factoryMethod, Object[] args) {
            return super.instantiate(beanDefinition, beanName, owner, factoryBean, factoryMethod, this.proxyFactory.proxy(args, factoryMethod.getParameterTypes()));
        }
    }
}

