/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.plugin.osgi.hostcomponents.ContextClassLoaderStrategy;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class OsgiServiceDefinition {
    private final Object component;
    private final ContextClassLoaderStrategy contextClassLoaderStrategy;
    private final Class<?>[] interfaces;
    private final String name;
    private final boolean trackBundle;

    public OsgiServiceDefinition(Builder builder) {
        this.component = builder.component;
        this.contextClassLoaderStrategy = builder.contextClassLoaderStrategy;
        this.name = builder.name;
        this.interfaces = (Class[])builder.interfaces.build().toArray((Object[])new Class[0]);
        this.trackBundle = builder.trackBundle;
    }

    @Nonnull
    public Object getComponent() {
        return this.component;
    }

    @Nonnull
    public ContextClassLoaderStrategy getContextClassLoaderStrategy() {
        return this.contextClassLoaderStrategy;
    }

    @Nonnull
    public Class<?>[] getInterfaces() {
        return this.interfaces;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public boolean isTrackBundle() {
        return this.trackBundle;
    }

    public static class Builder
    extends BuilderSupport {
        private final Object component;
        private final ImmutableList.Builder<Class<?>> interfaces;
        private ContextClassLoaderStrategy contextClassLoaderStrategy;
        private String name;
        private boolean trackBundle;

        public Builder(@Nonnull Object component) {
            this.component = Objects.requireNonNull(component, "component");
            this.contextClassLoaderStrategy = ContextClassLoaderStrategy.USE_HOST;
            this.interfaces = ImmutableList.builder();
        }

        @Nonnull
        public OsgiServiceDefinition build() {
            return new OsgiServiceDefinition(this);
        }

        @Nonnull
        public Builder contextClassLoaderStrategy(@Nonnull ContextClassLoaderStrategy value) {
            this.contextClassLoaderStrategy = Objects.requireNonNull(value, "contextClassLoaderStrategy");
            return this;
        }

        @Nonnull
        public Builder interfaces(@Nullable Class<?> value, Class<?> ... moreValues) {
            Builder.addIf(Objects::nonNull, this.interfaces, value, (Object[])moreValues);
            return this;
        }

        @Nonnull
        public Builder interfaces(@Nullable Iterable<Class<?>> values) {
            Builder.addIf(Objects::nonNull, this.interfaces, values);
            return this;
        }

        @Nonnull
        public Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        @Nonnull
        public Builder trackBundle(boolean value) {
            this.trackBundle = value;
            return this;
        }
    }
}

