/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.plugin.Application;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.main.PluginsConfiguration;
import com.atlassian.plugin.main.PluginsConfigurationBuilder;
import com.atlassian.plugin.manager.PluginPersistentStateStore;
import com.atlassian.plugin.osgi.container.PackageScannerConfiguration;
import com.atlassian.plugin.osgi.hostcomponents.HostComponentProvider;
import com.atlassian.stash.internal.HomeLayout;
import com.google.common.collect.ImmutableSet;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.ServletContextAware;

public class PluginConfigurationFactory
implements ServletContextAware {
    private static final Set<String> LIST_KEYS = ImmutableSet.of((Object)"bitbucket.plugins.list", (Object)"stash.plugins.list");
    private static final Logger log = LoggerFactory.getLogger(PluginConfigurationFactory.class);
    private final HomeLayout homeLayout;
    private final Application hostApplication;
    private final HostComponentProvider hostComponentProvider;
    private final ModuleDescriptorFactory moduleDescriptorFactory;
    private final PackageScannerConfiguration packageScannerConfiguration;
    private final PluginPersistentStateStore pluginPersistentStateStore;
    private ServletContext servletContext;

    public PluginConfigurationFactory(HomeLayout homeLayout, Application hostApplication, HostComponentProvider hostComponentProvider, ModuleDescriptorFactory moduleDescriptorFactory, PackageScannerConfiguration packageScannerConfiguration, PluginPersistentStateStore pluginPersistentStateStore) {
        this.homeLayout = homeLayout;
        this.hostApplication = hostApplication;
        this.hostComponentProvider = hostComponentProvider;
        this.moduleDescriptorFactory = moduleDescriptorFactory;
        this.packageScannerConfiguration = packageScannerConfiguration;
        this.pluginPersistentStateStore = pluginPersistentStateStore;
    }

    public PluginsConfiguration create() throws IOException {
        return new PluginsConfigurationBuilder().application(this.hostApplication).bundledPluginUrl(this.getBundledPluginsUrl()).bundledPluginCacheDirectory(this.homeLayout.getBundledPluginsDir().toFile()).frameworkBundleDirectory(this.getFrameworkBundlesDir()).hostComponentProvider(this.hostComponentProvider).moduleDescriptorFactory(this.moduleDescriptorFactory).osgiPersistentCache(this.homeLayout.getOsgiCacheDir().toFile()).packageScannerConfiguration(this.packageScannerConfiguration).pluginDirectory(this.homeLayout.getInstalledPluginsDir().toFile()).pluginStateStore(this.pluginPersistentStateStore).useLegacyDynamicPluginDeployer(true).build();
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    private URL getBundledPluginsUrl() throws IOException {
        for (String listKey : LIST_KEYS) {
            String list = System.getProperty(listKey);
            if (!StringUtils.isNotBlank((CharSequence)list)) continue;
            try {
                return URI.create(list).toURL();
            }
            catch (MalformedURLException e) {
                log.warn(listKey + ": [" + list + "] is not a valid URL", (Throwable)e);
            }
        }
        File bundledPluginsDir = new File(this.servletContext.getRealPath("/WEB-INF/atlassian-bundled-plugins"));
        log.debug("Using bundled plugins from: {}", (Object)bundledPluginsDir);
        return bundledPluginsDir.toURI().toURL();
    }

    private File getFrameworkBundlesDir() {
        File bundlesDir = new File(this.servletContext.getRealPath("/WEB-INF/osgi-framework-bundles"));
        log.debug("Using OSGi framework bundles from: {}", (Object)bundlesDir);
        return bundlesDir;
    }
}

