/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.nutcluster.spring.context.SpringAware;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.atlassian.stash.internal.plugin.ClusteredPluginPersistentStateStore;
import com.atlassian.stash.internal.plugin.PluginOperationType;
import jakarta.annotation.Resource;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;

@SpringAware
public class PluginControllerOperation
implements Runnable,
Serializable {
    private final String key;
    private final PluginOperationType type;
    private volatile transient ClusteredPluginPersistentStateStore store;
    private volatile transient PluginAccessor accessor;
    private volatile transient PluginController controller;

    public PluginControllerOperation(String key, PluginOperationType type) {
        this.key = key;
        this.type = type;
    }

    @Override
    public void run() {
        try (ClusteredPluginPersistentStateStore.ReadOnlyMarker state = this.store.markReadOnly();){
            this.type.apply(this.accessor, this.controller, this.key);
        }
    }

    @Autowired
    public void setClusteredPluginPersistentStateStore(ClusteredPluginPersistentStateStore store) {
        this.store = store;
    }

    @Autowired
    public void setPluginAccessor(PluginAccessor accessor) {
        this.accessor = accessor;
    }

    @Resource(name="pluginManager")
    public void setPluginController(PluginController controller) {
        this.controller = controller;
    }
}

