/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.plugin.metadata.PluginMetadataManager;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

@Component
public class PluginKeys {
    private static final String BUNDLED_EXTERNAL_PLUGINS = "application-bundled-external-plugins.txt";
    private static final String BUNDLED_INTERNAL_PLUGINS = "application-bundled-internal-plugins.txt";
    private static final String OBSOLETE_PLUGINS = "application-obsolete-plugins.txt";
    private static final String REQUIRED_PLUGINS = "application-required-plugins.txt";
    private static final String SUFFIX_DISABLED_PLUGINS = "-disabled-plugins.txt";
    private static final Logger log = LoggerFactory.getLogger(PluginKeys.class);
    private final Set<String> bundled;
    private final Set<String> disabled;
    private final Set<String> externalBundled = PluginKeys.uncheckedRead("application-bundled-external-plugins.txt");
    private final Set<String> internalBundled = PluginKeys.uncheckedRead("application-bundled-internal-plugins.txt");
    private final Set<String> obsolete;
    private final Set<String> required;

    @Autowired
    public PluginKeys(@Value(value="#{applicationPropertiesService.mode}") ApplicationMode mode) {
        this.bundled = new ImmutableSet.Builder().addAll(this.internalBundled).addAll(this.externalBundled).build();
        this.disabled = PluginKeys.loadDisabled(mode);
        this.obsolete = mode == ApplicationMode.DEFAULT ? PluginKeys.loadObsolete() : Collections.emptySet();
        this.required = (Set)PluginKeys.uncheckedRead(REQUIRED_PLUGINS).stream().filter(key -> !this.disabled.contains(key)).collect(MoreCollectors.toImmutableSet());
    }

    @Nonnull
    public Set<String> getBundled() {
        return this.bundled;
    }

    @Nonnull
    public Set<String> getDisabled() {
        return this.disabled;
    }

    @Nonnull
    public Set<String> getExternalBundled() {
        return this.externalBundled;
    }

    @Nonnull
    public Set<String> getInternalBundled() {
        return this.internalBundled;
    }

    @Nonnull
    public Set<String> getObsolete() {
        return this.obsolete;
    }

    @Nonnull
    public Set<String> getRequired() {
        return this.required;
    }

    private static BufferedReader createReader(String resourceName) throws IOException {
        return new BufferedReader(new InputStreamReader(new ClassPathResource(resourceName, PluginMetadataManager.class).getInputStream(), StandardCharsets.US_ASCII));
    }

    private static Set<String> loadDisabled(ApplicationMode mode) {
        try {
            return PluginKeys.read(mode.name().toLowerCase(Locale.ROOT) + SUFFIX_DISABLED_PLUGINS);
        }
        catch (IOException | UncheckedIOException e) {
            throw new IllegalStateException("Disabled plugins for " + String.valueOf(mode) + " mode could not be loaded", e);
        }
    }

    private static Set<String> loadObsolete() {
        try {
            return PluginKeys.read(OBSOLETE_PLUGINS);
        }
        catch (IOException | UncheckedIOException e) {
            log.warn("Failed to load obsolete plugin keys", (Throwable)e);
            return Collections.emptySet();
        }
    }

    private static Set<String> read(String resourceName) throws IOException {
        try (BufferedReader reader = PluginKeys.createReader(resourceName);){
            Set set = (Set)reader.lines().filter(line -> !line.isEmpty() && !line.startsWith("#")).collect(MoreCollectors.toImmutableSet());
            return set;
        }
    }

    private static Set<String> uncheckedRead(String resourceName) {
        try {
            return PluginKeys.read(resourceName);
        }
        catch (IOException e) {
            throw new UncheckedIOException(resourceName + " could not be loaded", e);
        }
    }
}

