/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;

public enum PluginOperationType {
    DISABLE_MODULE{

        @Override
        public void apply(PluginAccessor accessor, PluginController controller, String key) {
            controller.disablePluginModule(key);
        }
    }
    ,
    DISABLE_PLUGIN{

        @Override
        public void apply(PluginAccessor accessor, PluginController controller, String key) {
            controller.disablePlugin(key);
        }
    }
    ,
    ENABLE_MODULE{

        @Override
        public void apply(PluginAccessor accessor, PluginController controller, String key) {
            controller.enablePluginModule(key);
        }
    }
    ,
    ENABLE_PLUGIN{

        @Override
        public void apply(PluginAccessor accessor, PluginController controller, String key) {
            controller.enablePlugins(new String[]{key});
        }
    }
    ,
    REVERT_RESTART_REQUIRED{

        @Override
        public void apply(PluginAccessor accessor, PluginController controller, String key) {
            controller.revertRestartRequiredChange(key);
        }
    }
    ,
    SCAN_FOR_PLUGINS{

        @Override
        public void apply(PluginAccessor accessor, PluginController controller, String key) {
            controller.scanForNewPlugins();
        }
    }
    ,
    UNINSTALL_PLUGIN{

        @Override
        public void apply(PluginAccessor accessor, PluginController controller, String key) {
            Plugin plugin = accessor.getPlugin(key);
            if (plugin != null) {
                controller.uninstall(plugin);
            }
        }
    };


    public abstract void apply(PluginAccessor var1, PluginController var2, String var3);
}

