/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.bitbucket.util.concurrent.LockGuard;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.manager.PluginEnabledState;
import com.atlassian.plugin.manager.PluginPersistentState;
import com.atlassian.stash.internal.BuildInfo;
import com.atlassian.stash.internal.HomeLayout;
import com.atlassian.stash.internal.plugin.ClusteredPluginPersistentStateStore;
import com.atlassian.stash.internal.plugin.DelegatingPluginPersistentState;
import com.atlassian.stash.internal.plugin.PluginKeys;
import com.google.common.collect.Maps;
import jakarta.annotation.Nonnull;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PluginUpgradeHelper {
    private static final Logger log = LoggerFactory.getLogger(PluginUpgradeHelper.class);
    private final BuildInfo buildInfo;
    private final HomeLayout homeLayout;
    private final LockService lockService;
    private final PluginKeys pluginKeys;
    private final ClusteredPluginPersistentStateStore store;
    private boolean anyPluginDisabled;
    private volatile Function<PluginPersistentState, PluginPersistentState> wrapper;

    @Autowired
    public PluginUpgradeHelper(BuildInfo buildInfo, HomeLayout homeLayout, LockService lockService, PluginKeys pluginKeys, ClusteredPluginPersistentStateStore store) {
        this.buildInfo = buildInfo;
        this.homeLayout = homeLayout;
        this.lockService = lockService;
        this.pluginKeys = pluginKeys;
        this.store = store;
        this.wrapper = Function.identity();
    }

    public void clear() {
        this.anyPluginDisabled = false;
    }

    public boolean isAnyPluginDisabled() {
        return this.anyPluginDisabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void withUpgrade(Runnable runnable) {
        Path upgradeMarker = this.homeLayout.getUpgradesDir().resolve("disable-plugins");
        if (this.isUpgraded(upgradeMarker)) {
            runnable.run();
            return;
        }
        UpgradeState state = new UpgradeState(this.pluginKeys.getBundled(), this.pluginKeys.getRequired());
        this.wrapper = delegate -> new UpgradePluginPersistentState((PluginPersistentState)delegate, state);
        try {
            runnable.run();
        }
        finally {
            this.wrapper = Function.identity();
        }
        boolean marked = this.writeMarker(upgradeMarker);
        if (state.isUpdated()) {
            this.anyPluginDisabled = state.containsDisabledPlugins();
            PluginPersistentState upgradedState = state.applyTo(this.store.load());
            if (marked) {
                this.store.save(upgradedState);
            } else {
                try (ClusteredPluginPersistentStateStore.ReadOnlyMarker ignored = this.store.markReadOnly();){
                    this.store.save(upgradedState);
                }
            }
        }
    }

    @Nonnull
    PluginPersistentState wrap(@Nonnull PluginPersistentState state) {
        return this.wrapper.apply(state);
    }

    private boolean isUpgraded(Path upgradeMarker) {
        String markerBuild;
        try {
            markerBuild = MoreFiles.toString((Path)upgradeMarker, (Charset)StandardCharsets.UTF_8);
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            return false;
        }
        catch (IOException e) {
            log.warn("Failed to read plugin upgrade configuration file. Incompatible plugins may fail", (Throwable)e);
            return true;
        }
        return this.buildInfo.isCompatible(markerBuild);
    }

    private boolean writeMarker(@Nonnull Path upgradeMarker) {
        block15: {
            try (LockGuard ignored = LockGuard.lock((Lock)this.lockService.getLock("bitbucket:disable-plugins"));){
                boolean bl;
                block16: {
                    if (this.isUpgraded(upgradeMarker)) break block15;
                    BufferedWriter writer = Files.newBufferedWriter(upgradeMarker, StandardCharsets.UTF_8, new OpenOption[0]);
                    try {
                        writer.write(this.buildInfo.getBuildNumber());
                        bl = true;
                        if (writer == null) break block16;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (writer != null) {
                                try {
                                    ((Writer)writer).close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            log.warn("Plugin upgrade could not be persisted. User-installed plugins will be disabled again the next time {} starts.", (Object)Product.NAME, (Object)e);
                            break block15;
                        }
                    }
                    ((Writer)writer).close();
                }
                return bl;
            }
        }
        return false;
    }

    private static class UpgradeState {
        private final Set<String> bundledPlugins;
        private final Set<String> disabledPlugins;
        private final Set<String> enabledPlugins;
        private final Set<String> requiredPlugins;

        UpgradeState(Set<String> bundledPlugins, Set<String> requiredPlugins) {
            this.bundledPlugins = bundledPlugins;
            this.requiredPlugins = requiredPlugins;
            this.disabledPlugins = new HashSet<String>();
            this.enabledPlugins = new HashSet<String>();
        }

        @Nonnull
        PluginPersistentState applyTo(@Nonnull PluginPersistentState state) {
            if (this.enabledPlugins.isEmpty()) {
                log.info("Disabled {} plugins during {} upgrade", (Object)this.disabledPlugins.size(), (Object)Product.NAME);
            } else {
                log.info("Disabled {} plugins and enabled {} plugins during {} upgrade", new Object[]{this.disabledPlugins.size(), this.enabledPlugins.size(), Product.NAME});
            }
            return PluginPersistentState.Builder.create((PluginPersistentState)state).addPluginEnabledState(UpgradeState.toStateMap(this.disabledPlugins, false)).addPluginEnabledState(UpgradeState.toStateMap(this.enabledPlugins, true)).toState();
        }

        boolean containsDisabledPlugins() {
            return !this.disabledPlugins.isEmpty();
        }

        void disable(@Nonnull String pluginKey) {
            log.warn("Disabled {}", (Object)pluginKey);
            this.disabledPlugins.add(pluginKey);
        }

        void enable(@Nonnull String pluginKey) {
            log.warn("Enabled {}", (Object)pluginKey);
            this.enabledPlugins.add(pluginKey);
        }

        boolean isBundled(@Nonnull String pluginKey) {
            return this.bundledPlugins.contains(pluginKey);
        }

        boolean isRequired(@Nonnull String pluginKey) {
            return this.requiredPlugins.contains(pluginKey);
        }

        boolean isUpdated() {
            return !this.disabledPlugins.isEmpty() || !this.enabledPlugins.isEmpty();
        }

        private static Map<String, PluginEnabledState> toStateMap(Set<String> pluginKeys, boolean enabled) {
            return Maps.toMap(pluginKeys, ignored -> new PluginEnabledState(enabled, 0L));
        }
    }

    private static class UpgradePluginPersistentState
    extends DelegatingPluginPersistentState {
        private final UpgradeState state;

        UpgradePluginPersistentState(PluginPersistentState delegate, UpgradeState state) {
            super(delegate);
            this.state = state;
        }

        @Override
        public boolean isEnabled(Plugin plugin) {
            String key = plugin.getKey();
            if (this.state.isBundled(key)) {
                boolean enabled = super.isEnabled(plugin);
                if (!enabled && this.state.isRequired(key)) {
                    this.state.enable(key);
                    enabled = true;
                }
                return enabled;
            }
            this.state.disable(key);
            return false;
        }
    }
}

