/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.bitbucket.hook.BaseScmHookModuleDescriptor;
import com.atlassian.bitbucket.hook.repository.PostRepositoryHook;
import com.atlassian.bitbucket.hook.repository.PreRepositoryHook;
import com.atlassian.bitbucket.hook.repository.RepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookType;
import com.atlassian.bitbucket.hook.repository.RepositoryMergeCheck;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.scope.ScopeType;
import com.atlassian.bitbucket.setting.SettingsValidator;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.hostcontainer.HostContainer;
import com.atlassian.plugin.internal.module.Dom4jDelegatingElement;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.osgi.factory.OsgiPlugin;
import com.atlassian.plugin.util.validation.ValidationException;
import com.atlassian.plugin.web.WebFragmentHelper;
import com.atlassian.plugin.web.descriptors.ConditionElementParser;
import com.atlassian.stash.internal.plugin.ValidatorModuleDescriptor;
import com.atlassian.stash.internal.plugin.WebResourceGenerationHelper;
import com.atlassian.stash.internal.plugin.web.fragments.ConfigurationFormModuleDescriptor;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.TypeVariable;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.osgi.framework.ServiceRegistration;

public class RepositoryHookModuleDescriptor
extends BaseScmHookModuleDescriptor<Object>
implements ValidatorModuleDescriptor<Object> {
    public static final String XML_ELEMENT_NAME = "repository-hook";
    public static final String XML_ELEMENT_NAME_MERGE_CHECK = "merge-check";
    public static final String XML_ELEMENT_NAME_POST_RECEIVE_HOOK = "post-receive-hook";
    public static final String XML_ELEMENT_NAME_PRE_RECEIVE_HOOK = "pre-receive-hook";
    public static final String XML_ELEMENT_NAME_REPOSITORY_MERGE_CHECK = "repository-merge-check";
    private static final String ATT_CONFIGURABLE = "configurable";
    private static final String ELEMENT_SCOPES = "scopes";
    private static final String ELEMENT_SCOPE = "scope";
    private final ConditionElementParser.ConditionFactory conditionFactory;
    private final HostContainer hostContainer;
    private final I18nService i18nService;
    private final WebFragmentHelper webFragmentHelper;
    private final WebResourceGenerationHelper webResourceGenerationHelper;
    private boolean configurable;
    private ConfigurationFormModuleDescriptor configuredFormModuleDescriptor;
    private ServiceRegistration configurationFormRegistration;
    private String iconPath;
    private boolean preHook;
    private boolean preMergeHook;
    private boolean postHook;
    private Class<?> requestType;
    private Set<ScopeType> scopeTypes;
    private SettingsValidator validator;
    private String validatorClassName;

    public RepositoryHookModuleDescriptor(ModuleFactory moduleFactory, ConditionElementParser.ConditionFactory conditionFactory, WebFragmentHelper webFragmentHelper, HostContainer hostContainer, I18nService i18nService, WebResourceGenerationHelper webResourceGenerationHelper) {
        super(moduleFactory);
        this.conditionFactory = conditionFactory;
        this.i18nService = i18nService;
        this.hostContainer = hostContainer;
        this.webResourceGenerationHelper = webResourceGenerationHelper;
        this.webFragmentHelper = webFragmentHelper;
    }

    public <T extends RepositoryHookRequest> PostRepositoryHook<T> asPostHookFor(Class<T> hookRequestClass) {
        return this.isPostHookFor(hookRequestClass) ? (PostRepositoryHook)this.getModule() : null;
    }

    public <T extends RepositoryHookRequest> PreRepositoryHook<T> asPreHookFor(Class<T> hookRequestClass) {
        return this.isPreHookFor(hookRequestClass) ? (PreRepositoryHook)this.getModule() : null;
    }

    public void disabled() {
        if (this.configurationFormRegistration != null) {
            this.configurationFormRegistration.unregister();
            this.configurationFormRegistration = null;
        }
        this.validator = null;
        super.disabled();
    }

    public void enabled() {
        super.enabled();
        this.preHook = this.module instanceof PreRepositoryHook;
        this.preMergeHook = this.module instanceof RepositoryMergeCheck;
        this.postHook = this.module instanceof PostRepositoryHook;
        if (!this.preHook && !this.postHook) {
            throw new PluginParseException(String.format("Hook must implement %s or %s", PreRepositoryHook.class.getSimpleName(), PostRepositoryHook.class.getSimpleName()));
        }
        TypeVariable requestTypeVariable = this.preHook ? PreRepositoryHook.class.getTypeParameters()[0] : PostRepositoryHook.class.getTypeParameters()[0];
        this.requestType = (Class)MoreObjects.firstNonNull((Object)TypeUtils.getRawType(requestTypeVariable, this.module.getClass()), RepositoryHookRequest.class);
        if (this.configuredFormModuleDescriptor != null) {
            this.configurationFormRegistration = ((OsgiPlugin)this.getPlugin()).getBundle().getBundleContext().registerService(ModuleDescriptor.class.getName(), (Object)this.configuredFormModuleDescriptor, null);
        }
        this.validator = this.createValidator();
    }

    @Nullable
    public String getConfigFormKey() {
        return this.configuredFormModuleDescriptor != null ? this.configuredFormModuleDescriptor.getCompleteKey() : null;
    }

    @Nullable
    public String getConfigFormView() {
        return this.configuredFormModuleDescriptor != null ? this.configuredFormModuleDescriptor.getView() : null;
    }

    @Nullable
    public String getI18nDescription() {
        return this.getDescriptionKey() != null ? this.i18nService.getText(this.getDescriptionKey(), this.getDescription(), new Object[0]) : this.getDescription();
    }

    public String getI18nName() {
        return this.getI18nNameKey() != null ? this.i18nService.getText(this.getI18nNameKey(), this.getName(), new Object[0]) : this.getName();
    }

    public String getIconPath() {
        return this.iconPath;
    }

    @Nonnull
    public Set<ScopeType> getScopeTypes() {
        return this.scopeTypes;
    }

    @Nonnull
    public RepositoryHookType getType() {
        if (this.preMergeHook) {
            return RepositoryHookType.PRE_PULL_REQUEST_MERGE;
        }
        if (this.preHook) {
            return RepositoryHookType.PRE_RECEIVE;
        }
        return RepositoryHookType.POST_RECEIVE;
    }

    @Override
    @Nullable
    public SettingsValidator getValidator() {
        return this.validator;
    }

    public void init(@Nonnull Plugin plugin, @Nonnull Element element) throws PluginParseException {
        String configurableAttribute;
        org.dom4j.Element validatorElement;
        org.dom4j.Element configElement;
        org.dom4j.Element iconElement;
        org.dom4j.Element delegateElement = ((Dom4jDelegatingElement)element).getDelegate();
        String elementName = delegateElement.getName();
        if (XML_ELEMENT_NAME_POST_RECEIVE_HOOK.equals(elementName) || XML_ELEMENT_NAME_PRE_RECEIVE_HOOK.equals(elementName) || XML_ELEMENT_NAME_MERGE_CHECK.equals(elementName)) {
            delegateElement.addAttribute(ATT_CONFIGURABLE, "false");
        }
        if ((iconElement = delegateElement.element("icon")) != null) {
            this.iconPath = iconElement.getTextTrim();
        }
        if ((configElement = delegateElement.element("config-form")) != null) {
            if (!(plugin instanceof OsgiPlugin)) {
                throw new PluginParseException("repository-hook can only be used in OSGi plugins");
            }
            configElement = this.processConfig(delegateElement, configElement);
            this.configuredFormModuleDescriptor = new ConfigurationFormModuleDescriptor(this.moduleFactory, this.hostContainer, this.webResourceGenerationHelper);
            this.configuredFormModuleDescriptor.init(plugin, (Element)new Dom4jDelegatingElement(configElement));
        }
        if ((validatorElement = delegateElement.element("validator")) != null) {
            this.validatorClassName = validatorElement.getStringValue();
        }
        boolean bl = this.configurable = !"false".equalsIgnoreCase(configurableAttribute = delegateElement.attributeValue(ATT_CONFIGURABLE));
        if (this.configurable && elementName == null) {
            throw new PluginParseException("Then name attribute is required unless configurable=\"false\"");
        }
        org.dom4j.Element scopesElement = delegateElement.element(ELEMENT_SCOPES);
        if (scopesElement == null) {
            this.scopeTypes = ImmutableSet.of((Object)ScopeType.REPOSITORY);
        } else {
            List scopeElement = scopesElement.elements(ELEMENT_SCOPE);
            if (scopeElement == null || scopeElement.isEmpty()) {
                throw new PluginParseException("Scopes element must have at least one scope");
            }
            this.scopeTypes = scopeElement.stream().map(scope -> {
                String scopeStringValue = scope.getText();
                if (StringUtils.isEmpty((CharSequence)scopeStringValue)) {
                    throw new PluginParseException("Scope cannot be empty, must be either 'project' or 'repository'");
                }
                try {
                    return ScopeType.valueOf((String)StringUtils.upperCase((String)scopeStringValue, (Locale)Locale.ROOT));
                }
                catch (IllegalArgumentException e) {
                    throw new PluginParseException("Invalid scope: " + scopeStringValue + ", must be either 'repository' or 'project'");
                }
            }).collect(Collectors.toSet());
        }
        super.init(plugin, (Element)new Dom4jDelegatingElement(delegateElement));
    }

    public boolean isConfigurable() {
        return this.configurable;
    }

    public boolean isPostHookFor(Class<? extends RepositoryHookRequest> requestClass) {
        return this.postHook && this.isCompatible(requestClass);
    }

    public boolean isPreHookFor(Class<? extends RepositoryHookRequest> requestClass) {
        return this.preHook && this.isCompatible(requestClass);
    }

    protected void validate(Element element) {
        super.validate(element);
        if (element.attributeValue("class") == null) {
            throw new ValidationException(List.of("The class for the hook implementation is required"));
        }
    }

    private SettingsValidator createValidator() {
        if (this.validatorClassName != null) {
            try {
                Class validatorClass = this.plugin.loadClass(this.validatorClassName, this.getClass());
                return (SettingsValidator)((OsgiPlugin)this.getPlugin()).getContainerAccessor().createBean(validatorClass);
            }
            catch (ClassNotFoundException e) {
                throw new PluginParseException(String.format("Hook validator class '%s' not found", this.validatorClassName), (Throwable)e);
            }
        }
        if (this.module instanceof SettingsValidator) {
            return (SettingsValidator)this.getModule();
        }
        return null;
    }

    private boolean isCompatible(Class<? extends RepositoryHookRequest> requestClass) {
        return this.requestType.isAssignableFrom(requestClass);
    }

    private org.dom4j.Element processConfig(org.dom4j.Element moduleElement, org.dom4j.Element configElement) {
        configElement = configElement.createCopy();
        configElement.setParent(moduleElement.getParent());
        configElement.addAttribute("key", moduleElement.attributeValue("key") + "-config-form");
        return configElement;
    }
}

