/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.plugin.osgi.container.PackageScannerConfiguration;
import com.atlassian.plugin.osgi.container.impl.DefaultPackageScannerConfiguration;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.google.common.collect.Maps;
import jakarta.servlet.ServletContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=PackageScannerConfiguration.class)
@Component
public class StashPackageScannerConfiguration
extends DefaultPackageScannerConfiguration {
    public static final String OSGI_BUNDLED_PLUGINS = "package-bundled-internal-plugins.properties";
    private static final String EXCLUDED_PACKAGES = "package-excludes.properties";
    private static final String EXPORTED_VERSIONS = "library-export-versions.properties";
    private static final String INCLUDED_PACKAGES = "package-includes.properties";
    private static final String PUBLIC_EXCLUDED_PACKAGES = "package-public-excludes.properties";
    private static final String PUBLIC_INCLUDED_PACKAGES = "package-public-includes.properties";
    private static final Logger log = LoggerFactory.getLogger(StashPackageScannerConfiguration.class);

    public StashPackageScannerConfiguration() {
        super(StashPackageScannerConfiguration.determineVersion());
        this.setSystemBundlePackages();
        this.setPublicPackages();
        this.setApplicationBundledInternalPlugins(StashPackageScannerConfiguration.loadProperties(OSGI_BUNDLED_PLUGINS).stringPropertyNames());
    }

    @Autowired
    public void setServletContext(ServletContext servletContext) {
        super.setServletContext(servletContext);
    }

    private static String determineVersion() {
        Properties properties = StashPackageScannerConfiguration.loadProperties("META-INF/maven/com.atlassian.plugins/atlassian-plugins-core/pom.properties");
        return properties.getProperty("version");
    }

    private static Properties loadProperties(String resourceName) {
        Properties properties = new Properties();
        try (InputStream in = StashPackageScannerConfiguration.class.getClassLoader().getResourceAsStream(resourceName);){
            properties.load(in);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return properties;
    }

    private void setPublicPackages() {
        Set<String> publicIncludes = StashPackageScannerConfiguration.loadProperties(PUBLIC_INCLUDED_PACKAGES).stringPropertyNames();
        this.setOsgiPublicPackages(publicIncludes);
        Set<String> publicExcludes = StashPackageScannerConfiguration.loadProperties(PUBLIC_EXCLUDED_PACKAGES).stringPropertyNames();
        this.setOsgiPublicPackagesExcludes(publicExcludes);
        this.setPackageVersions((Map)Maps.fromProperties((Properties)StashPackageScannerConfiguration.loadProperties(EXPORTED_VERSIONS)));
    }

    private void setSystemBundlePackages() {
        List packageIncludes = StashPackageScannerConfiguration.loadProperties(INCLUDED_PACKAGES).stringPropertyNames().stream().toList();
        this.setPackageIncludes(packageIncludes);
        List packageExcludes = StashPackageScannerConfiguration.loadProperties(EXCLUDED_PACKAGES).stringPropertyNames().stream().toList();
        this.setPackageExcludes(packageExcludes);
        this.setTreatDeprecatedPackagesAsPublic(true);
    }
}

