/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.event.NotificationException;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.loaders.PluginLoader;
import com.atlassian.plugin.manager.DefaultPluginManager;
import com.atlassian.plugin.manager.PluginPersistentState;
import com.atlassian.plugin.manager.PluginPersistentStateStore;
import com.atlassian.stash.internal.plugin.PluginKeys;
import com.atlassian.stash.internal.plugin.PluginUpgradeHelper;
import com.atlassian.stash.internal.plugin.event.PluginInstallRequestedEvent;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class StashPluginManager
extends DefaultPluginManager {
    private final PluginEventManager eventManager;
    private final PluginKeys pluginKeys;
    private final PluginUpgradeHelper upgradeHelper;
    private volatile boolean isEarlyStartup;

    public StashPluginManager(PluginPersistentStateStore store, List<PluginLoader> pluginLoaders, ModuleDescriptorFactory moduleDescriptorFactory, PluginEventManager eventManager, PluginKeys pluginKeys, PluginUpgradeHelper upgradeHelper) {
        super(store, pluginLoaders, moduleDescriptorFactory, eventManager);
        this.eventManager = eventManager;
        this.pluginKeys = pluginKeys;
        this.upgradeHelper = upgradeHelper;
    }

    public void earlyStartup() {
        this.isEarlyStartup = true;
        try {
            super.earlyStartup();
        }
        finally {
            this.isEarlyStartup = false;
        }
    }

    public void init() throws PluginParseException, NotificationException {
        this.upgradeHelper.withUpgrade(() -> super.init());
    }

    protected void addPlugins(PluginLoader loader, Collection<Plugin> pluginsToInstall) throws PluginParseException {
        this.filterDisabledPlugins(pluginsToInstall);
        if (this.isEarlyStartup) {
            this.eventManager.broadcast((Object)new PluginInstallRequestedEvent((Object)this, pluginsToInstall.size()));
        }
        super.addPlugins(loader, pluginsToInstall);
    }

    protected PluginPersistentState getState() {
        return this.upgradeHelper.wrap(super.getState());
    }

    private void filterDisabledPlugins(Collection<Plugin> plugins) {
        Set<String> disabledKeys = this.pluginKeys.getDisabled();
        plugins.removeIf(plugin -> disabledKeys.contains(plugin.getKey()));
    }
}

