/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.api.DynamicWebInterfaceManager;
import com.atlassian.plugin.web.api.descriptors.WebFragmentModuleDescriptor;
import com.atlassian.plugin.web.descriptors.DefaultWebItemModuleDescriptor;
import com.atlassian.stash.internal.plugin.StashWebLabel;
import org.apache.commons.lang3.StringUtils;

public class StashWebItemModuleDescriptor
extends DefaultWebItemModuleDescriptor {
    public static final String XML_ELEMENT_NAME = "web-item";
    private final I18nService i18nService;
    private Element element;

    public StashWebItemModuleDescriptor(DynamicWebInterfaceManager webInterfaceManager, I18nService i18nService) {
        super((WebInterfaceManager)webInterfaceManager);
        this.i18nService = i18nService;
    }

    public void enabled() {
        super.enabled();
        if (this.element.element("label") != null) {
            this.label = new StashWebLabel(this.element.element("label"), this.webInterfaceManager.getWebFragmentHelper(), this.contextProvider, (WebFragmentModuleDescriptor)this, this.i18nService);
        }
        if (this.element.element("tooltip") != null) {
            this.tooltip = new StashWebLabel(this.element.element("tooltip"), this.webInterfaceManager.getWebFragmentHelper(), this.contextProvider, (WebFragmentModuleDescriptor)this, this.i18nService);
        }
        this.webInterfaceManager.refresh();
    }

    public String getDescription() {
        String key = super.getDescriptionKey();
        String description = super.getDescription();
        if (StringUtils.isNotBlank((CharSequence)key)) {
            return this.i18nService.getText(key, description, new Object[0]);
        }
        return description;
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.element = element;
    }
}

