/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.plugin.web.WebFragmentHelper;
import com.atlassian.plugin.web.api.descriptors.WebFragmentModuleDescriptor;
import com.atlassian.plugin.web.model.DefaultWebLabel;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class StashWebLabel
extends DefaultWebLabel {
    private final I18nService i18nService;
    private final String defaultText;

    public StashWebLabel(Element labelEl, WebFragmentHelper webFragmentHelper, ContextProvider contextProvider, WebFragmentModuleDescriptor descriptor, I18nService i18nService) throws PluginParseException {
        super(labelEl, webFragmentHelper, contextProvider, descriptor);
        this.i18nService = i18nService;
        this.defaultText = labelEl.getTextTrim();
    }

    public String getDisplayableLabel(HttpServletRequest req, Map<String, Object> origContext) {
        HashMap<String, Object> tmpContext = new HashMap<String, Object>(origContext);
        tmpContext.putAll(this.getContextMap(tmpContext));
        if (this.getKey() != null) {
            ArrayList<String> arguments = new ArrayList<String>();
            if (this.params != null && !this.params.isEmpty()) {
                for (String key : this.params.keySet()) {
                    if (!key.startsWith("param")) continue;
                    arguments.add(this.getWebFragmentHelper().renderVelocityFragment((String)this.params.get(key), tmpContext));
                }
            }
            return this.i18nService.getText(this.getKey(), this.defaultText, arguments.toArray());
        }
        return this.getWebFragmentHelper().renderVelocityFragment(this.defaultText, tmpContext);
    }
}

