/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin.scan;

import com.atlassian.stash.internal.plugin.scan.PluginPathScanner;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.ResourceUtils;

public class ClassLoaderPluginPathScanner
implements PluginPathScanner {
    private static final Logger log = LoggerFactory.getLogger(ClassLoaderPluginPathScanner.class);
    private final ClassLoader classLoader;

    public ClassLoaderPluginPathScanner(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public List<String> getPaths(String prefix) {
        try {
            Resource[] resources = new PathMatchingResourcePatternResolver(this.classLoader).getResources("classpath*:" + StringUtils.appendIfMissing((String)prefix, (CharSequence)"/", (CharSequence[])new CharSequence[0]) + "**");
            ArrayList<String> paths = new ArrayList<String>(resources.length);
            for (Resource resource : resources) {
                String path = this.getPathFromUri(resource);
                if (path == null) {
                    log.warn("Ignoring {}; its URI is invalid", (Object)resource);
                    continue;
                }
                int i = prefix.length() == 1 ? path.lastIndexOf(47) : path.indexOf(prefix);
                paths.add(path.substring(i));
            }
            return paths;
        }
        catch (IOException e) {
            log.error("Error scanning classpath {} in {}", new Object[]{this.classLoader, prefix, e});
            return new ArrayList<String>();
        }
    }

    @Nullable
    private String getPathFromUri(Resource resource) throws IOException {
        try {
            return resource.getURI().toString();
        }
        catch (IOException e) {
            if (e.getCause() instanceof URISyntaxException) {
                try {
                    return this.maybeGetPathFromUrl(resource);
                }
                catch (IOException | URISyntaxException ex) {
                    e.addSuppressed(ex);
                }
            }
            throw e;
        }
    }

    @Nullable
    private String maybeGetPathFromUrl(Resource resource) throws IOException, URISyntaxException {
        URL url;
        String original;
        String normalized;
        if (SystemUtils.IS_OS_WINDOWS && (normalized = (original = (url = resource.getURL()).toString()).replace('\\', '/')) != original) {
            return ResourceUtils.toURI((String)normalized).toString();
        }
        return null;
    }
}

