/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin.scan;

import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.loaders.DirectoryScanner;
import com.atlassian.plugin.loaders.classloading.DeploymentUnit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedDirectoryScanner
extends DirectoryScanner {
    private static final Logger log = LoggerFactory.getLogger(ExtendedDirectoryScanner.class);

    public ExtendedDirectoryScanner(File pluginsDirectory) {
        super(pluginsDirectory);
    }

    public void remove(DeploymentUnit unit) throws PluginException {
        File pluginFile = unit.getPath();
        try {
            Files.delete(pluginFile.toPath());
        }
        catch (AccessDeniedException e) {
            log.info("Plugin file <{}> exists but we do not have permission to remove it. Ignoring.", (Object)pluginFile.getAbsolutePath());
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            log.debug("Plugin file <{}> doesn't exist to delete.  Ignoring.", (Object)pluginFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new PluginException("Unable to delete file: " + pluginFile.getAbsolutePath());
        }
        this.clear(pluginFile);
    }
}

