/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin.scan;

import com.atlassian.bitbucket.content.SimplePath;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.plugin.osgi.factory.OsgiPlugin;
import com.atlassian.stash.internal.plugin.scan.PluginPathScanner;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiBundledPathScanner
implements PluginPathScanner {
    private static final Logger log = LoggerFactory.getLogger(OsgiBundledPathScanner.class);
    private final OsgiPlugin plugin;

    public OsgiBundledPathScanner(OsgiPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public List<String> getPaths(String prefix) {
        return OsgiBundledPathScanner.scanForPaths(this.plugin.getBundle(), prefix);
    }

    private static List<String> scanForPaths(Bundle bundle, String prefix) {
        ArrayList<String> paths = new ArrayList<String>();
        OsgiBundledPathScanner.scanPath(bundle, prefix, prefix, paths, true);
        if (paths.isEmpty()) {
            log.debug("No resources found at {} in bundle {}", (Object)prefix, (Object)bundle.getSymbolicName());
        }
        return paths;
    }

    private static void scanPath(Bundle bundle, String root, String prefix, List<String> paths, boolean firstLevel) {
        Enumeration entryPaths = bundle.getEntryPaths(prefix);
        if (entryPaths == null) {
            if (firstLevel) {
                log.warn("Cannot scan directory {} in bundle {}; it does not exist", (Object)prefix, (Object)bundle.getSymbolicName());
            }
            return;
        }
        MoreStreams.streamEnumeration((Enumeration)entryPaths).forEach(fullPath -> {
            if (fullPath.endsWith("/")) {
                OsgiBundledPathScanner.scanPath(bundle, root, fullPath, paths, false);
            } else {
                String path = fullPath.substring(root.length() - 1);
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                paths.add(SimplePath.join((String)root, (String)path));
            }
        });
    }
}

