/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin.scan;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.impl.StaticPlugin;
import com.atlassian.plugin.osgi.factory.OsgiPlugin;
import com.atlassian.plugin.servlet.ServletContextFactory;
import com.atlassian.stash.internal.plugin.scan.ClassLoaderPluginPathScanner;
import com.atlassian.stash.internal.plugin.scan.OsgiBundledPathScanner;
import com.atlassian.stash.internal.plugin.scan.PluginPathScanner;
import com.atlassian.stash.internal.plugin.scan.StaticPluginPathScanner;

public class PluginPathScannerFactory {
    private final ServletContextFactory servletContextFactory;

    public PluginPathScannerFactory(ServletContextFactory servletContextFactory) {
        this.servletContextFactory = servletContextFactory;
    }

    public PluginPathScanner forPlugin(Plugin plugin) {
        if (plugin instanceof OsgiPlugin) {
            return new OsgiBundledPathScanner((OsgiPlugin)plugin);
        }
        if (plugin instanceof StaticPlugin) {
            return new ClassLoaderPluginPathScanner(plugin.getClassLoader());
        }
        throw new UnsupportedOperationException("Plugin path scanning not supported for class type " + plugin.getClass().getCanonicalName());
    }

    public PluginPathScanner forPlugin(Plugin plugin, boolean webContextStatic) {
        if (webContextStatic) {
            return new StaticPluginPathScanner(this.servletContextFactory);
        }
        return this.forPlugin(plugin);
    }
}

