/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.plugin.scan;

import com.atlassian.plugin.servlet.ServletContextFactory;
import com.atlassian.stash.internal.plugin.scan.PluginPathScanner;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticPluginPathScanner
implements PluginPathScanner {
    private static final Logger log = LoggerFactory.getLogger(StaticPluginPathScanner.class);
    private final ServletContextFactory servletContextFactory;

    public StaticPluginPathScanner(ServletContextFactory servletContextFactory) {
        this.servletContextFactory = servletContextFactory;
    }

    @Override
    public List<String> getPaths(String prefix) {
        ArrayList<String> paths = new ArrayList<String>();
        this.recursePath(prefix, paths);
        return paths;
    }

    private void recursePath(String prefix, List<String> paths) {
        Set resourcePaths = this.servletContextFactory.getServletContext().getResourcePaths(prefix);
        if (resourcePaths == null) {
            log.warn("Cannot scan directory {} in web static as it does not exist", (Object)prefix);
            return;
        }
        for (String resourcePath : resourcePaths) {
            if (resourcePath.endsWith("/")) {
                this.recursePath(resourcePath, paths);
                continue;
            }
            paths.add(resourcePath);
        }
    }
}

