/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.sal.message;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.core.message.AbstractI18nResolver;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=I18nResolver.class)
@Component(value="i18nResolver")
public class DefaultI18nResolver
extends AbstractI18nResolver {
    private final I18nService i18nService;

    public DefaultI18nResolver(I18nService i18nService) {
        this.i18nService = i18nService;
    }

    public String resolveText(String key, Serializable[] arguments) {
        return this.i18nService.getMessage(key, (Object[])arguments);
    }

    public String resolveText(Locale locale, String key, Serializable[] arguments) {
        return this.i18nService.getText(locale, key, null, (Object[])arguments);
    }

    public String getRawText(String key) {
        return this.i18nService.getMessagePattern(key);
    }

    public String getRawText(Locale locale, String key) {
        return this.i18nService.getMessagePattern(locale, key);
    }

    public Map<String, String> getAllTranslationsForPrefix(String prefix) {
        return this.i18nService.getAllTranslationsForPrefix(prefix);
    }

    public Map<String, String> getAllTranslationsForPrefix(String prefix, Locale locale) {
        return this.i18nService.getAllTranslationsForPrefix(prefix, locale);
    }
}

