/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.sal.permission;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.sal.api.permission.AuthorisationException;
import com.atlassian.sal.api.permission.NotAuthenticatedException;
import com.atlassian.sal.api.permission.PermissionEnforcer;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=PermissionEnforcer.class)
@Component(value="permissionEnforcer")
public class DefaultPermissionEnforcer
implements PermissionEnforcer {
    private final AuthenticationContext authenticationContext;
    private final I18nService i18nService;
    private final PermissionService permissionService;
    private final UserManager userManager;

    @Autowired
    public DefaultPermissionEnforcer(AuthenticationContext authenticationContext, I18nService i18nService, PermissionService permissionService, UserManager userManager) {
        this.authenticationContext = authenticationContext;
        this.i18nService = i18nService;
        this.permissionService = permissionService;
        this.userManager = userManager;
    }

    public void enforceAdmin() throws AuthorisationException {
        if (!this.isAdmin()) {
            throw this.throwAccessDenied();
        }
    }

    public void enforceAuthenticated() throws NotAuthenticatedException {
        if (!this.isAuthenticated()) {
            throw this.throwAccessDenied();
        }
    }

    public void enforceSiteAccess() throws AuthorisationException {
        UserKey user = this.userManager.getRemoteUserKey();
        boolean publicAccess = this.userManager.isAnonymousAccessEnabled();
        if (!publicAccess && !this.userManager.isLicensed(user)) {
            throw this.throwAccessDenied();
        }
    }

    public void enforceSystemAdmin() throws AuthorisationException {
        if (!this.isSystemAdmin()) {
            throw this.throwAccessDenied();
        }
    }

    public boolean isAdmin() {
        return this.permissionService.hasGlobalPermission(Permission.ADMIN);
    }

    public boolean isAuthenticated() {
        return this.authenticationContext.isAuthenticated();
    }

    public boolean isLicensed() {
        return this.permissionService.hasGlobalPermission(Permission.LICENSED_USER);
    }

    public boolean isLicensedOrLimitedUnlicensedUser() {
        return this.isLicensed();
    }

    public boolean isSystemAdmin() {
        return this.permissionService.hasGlobalPermission(Permission.SYS_ADMIN);
    }

    private AuthorisationException throwAccessDenied() {
        String message = this.i18nService.getMessage("bitbucket.service.accessdenied", new Object[0]);
        AccessDeniedException cause = new AccessDeniedException(message);
        throw this.authenticationContext.isAuthenticated() ? new AuthorisationException(message, (Throwable)cause) : new NotAuthenticatedException(message, (Throwable)cause);
    }
}

