/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.sal.scheduling;

import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.sal.api.scheduling.PluginJob;
import com.atlassian.sal.api.scheduling.PluginScheduler;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerRuntimeException;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=PluginScheduler.class)
@Component(value="pluginScheduler")
public class PluginSchedulerAdapter
implements PluginScheduler,
JobRunner {
    @VisibleForTesting
    static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)PluginScheduler.class.getName());
    private final SchedulerService schedulerService;
    private final ConcurrentMap<JobId, JobDescriptor> descriptors;

    @Autowired
    public PluginSchedulerAdapter(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
        this.descriptors = new ConcurrentHashMap<JobId, JobDescriptor>();
    }

    @PostConstruct
    public void registerJobRunner() {
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)this);
    }

    public void scheduleJob(String jobKey, Class<? extends PluginJob> jobClass, Map<String, Object> jobDataMap, Date startTime, long repeatInterval) {
        this.validateJobData(jobDataMap);
        JobId jobId = PluginSchedulerAdapter.toJobId(jobKey);
        JobDescriptor newDescriptor = new JobDescriptor(jobClass, jobDataMap);
        JobDescriptor oldDescriptor = this.descriptors.put(jobId, newDescriptor);
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.forInterval((long)repeatInterval, (Date)startTime));
        try {
            this.schedulerService.scheduleJob(jobId, jobConfig);
        }
        catch (SchedulerServiceException sse) {
            if (oldDescriptor == null) {
                this.descriptors.remove(jobKey, newDescriptor);
            } else {
                this.descriptors.replace(jobId, newDescriptor, oldDescriptor);
            }
            throw new SchedulerRuntimeException(sse.getMessage(), (Throwable)sse);
        }
    }

    public void unscheduleJob(String jobKey) {
        JobId jobId = PluginSchedulerAdapter.toJobId(jobKey);
        if (this.descriptors.remove(jobId) == null) {
            throw new IllegalArgumentException("Job descriptor not found for job '" + jobKey + "'");
        }
        this.schedulerService.unscheduleJob(jobId);
    }

    @Nonnull
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        JobDescriptor descriptor = (JobDescriptor)this.descriptors.get(jobRunnerRequest.getJobId());
        if (descriptor == null) {
            return JobRunnerResponse.aborted((String)"Job descriptor not found");
        }
        return descriptor.runJob();
    }

    @VisibleForTesting
    static JobId toJobId(String jobKey) {
        return JobId.of((String)(PluginScheduler.class.getSimpleName() + ":" + jobKey));
    }

    private void validateJobData(Map<String, Object> jobDataMap) {
        if (jobDataMap == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : jobDataMap.entrySet()) {
            Object value = entry.getValue();
            if (value == null || value instanceof Serializable) continue;
            throw new IllegalArgumentException(String.format("PluginScheduler requires job data to be Serializable. key={}, valueClass={}", entry.getKey(), value.getClass()));
        }
    }

    private static class JobDescriptor {
        private final Class<? extends PluginJob> jobClass;
        private final Map<String, Object> jobDataMap;

        private JobDescriptor(Class<? extends PluginJob> jobClass, Map<String, Object> jobDataMap) {
            this.jobClass = Objects.requireNonNull(jobClass, "jobClass");
            this.jobDataMap = jobDataMap;
        }

        @Nonnull
        JobRunnerResponse runJob() {
            PluginJob job;
            try {
                job = this.jobClass.newInstance();
            }
            catch (InstantiationException e) {
                return JobRunnerResponse.aborted((String)e.toString());
            }
            catch (IllegalAccessException e) {
                return JobRunnerResponse.aborted((String)e.toString());
            }
            job.execute(this.jobDataMap);
            return JobRunnerResponse.success();
        }
    }
}

