/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scheduling;

import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.stash.internal.darkfeature.InternalDarkFeatureManager;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

class DarkFeatureAwareJobRunner
implements JobRunner {
    private final InternalDarkFeatureManager darkFeatureManager;
    private final JobRunner delegate;
    private final String featureKey;

    private DarkFeatureAwareJobRunner(@Nonnull JobRunner delegate, @Nonnull String featureKey, @Nonnull InternalDarkFeatureManager darkFeatureManager) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.featureKey = Objects.requireNonNull(featureKey, "featureKey");
        this.darkFeatureManager = Objects.requireNonNull(darkFeatureManager, "darkFeatureManager");
    }

    @Nullable
    public JobRunnerResponse runJob(@Nonnull JobRunnerRequest request) {
        if (this.darkFeatureManager.isEnabledForAnyUser(this.featureKey).orElse(false).booleanValue()) {
            return this.delegate.runJob(request);
        }
        return this.skipExecution();
    }

    static JobRunner wrap(JobRunner delegate, String featureKey, InternalDarkFeatureManager darkFeatureManager) {
        return new DarkFeatureAwareJobRunner(delegate, featureKey, darkFeatureManager);
    }

    private JobRunnerResponse skipExecution() {
        return JobRunnerResponse.success((String)String.format("Skipping job [%s] execution, dark feature [%s] is not enabled for any user", this.delegate.getClass().getSimpleName(), this.featureKey));
    }
}

