/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scheduling;

import com.atlassian.bitbucket.dmz.features.RequireDarkFeature;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.caesium.impl.CaesiumSchedulerService;
import com.atlassian.scheduler.caesium.spi.CaesiumSchedulerConfiguration;
import com.atlassian.scheduler.caesium.spi.ClusteredJobDao;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.core.spi.RunDetailsDao;
import com.atlassian.stash.internal.darkfeature.InternalDarkFeatureManager;
import com.atlassian.stash.internal.scheduling.DarkFeatureAwareJobRunner;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service(value="schedulerService")
@AvailableToPlugins(value=SchedulerService.class)
public class DefaultSchedulerService
extends CaesiumSchedulerService {
    public static final String FEATURE_PARAMETER_KEY = "feature";
    private final InternalDarkFeatureManager darkFeatureManager;
    private final FeatureManager featureManager;

    @Autowired
    public DefaultSchedulerService(@Lazy InternalDarkFeatureManager darkFeatureManager, @Lazy FeatureManager featureManager, CaesiumSchedulerConfiguration config, RunDetailsDao runDetailsDao, ClusteredJobDao clusteredJobDao) {
        super(config, runDetailsDao, clusteredJobDao);
        this.darkFeatureManager = darkFeatureManager;
        this.featureManager = featureManager;
    }

    public void registerJobRunner(@Nonnull JobRunnerKey jobRunnerKey, @Nonnull JobRunner jobRunner) {
        Objects.requireNonNull(jobRunnerKey, "jobRunnerKey");
        Objects.requireNonNull(jobRunner, "jobRunner");
        Class jobRunnerClass = jobRunner.getClass();
        if (jobRunnerClass.isAnnotationPresent(RequireDarkFeature.class)) {
            super.registerJobRunner(jobRunnerKey, DarkFeatureAwareJobRunner.wrap(jobRunner, jobRunnerClass.getAnnotation(RequireDarkFeature.class).value(), this.darkFeatureManager));
        } else {
            super.registerJobRunner(jobRunnerKey, jobRunner);
        }
    }

    public void scheduleJob(@Nonnull JobId jobId, @Nonnull JobConfig jobConfig) throws SchedulerServiceException {
        if (this.isFeatureEnabled(jobConfig)) {
            super.scheduleJob(jobId, jobConfig);
        }
    }

    private boolean isFeatureEnabled(JobConfig jobConfig) {
        JobRunner jobRunner = this.getJobRunner(jobConfig.getJobRunnerKey());
        if (jobRunner == null || !jobConfig.getParameters().containsKey(FEATURE_PARAMETER_KEY)) {
            return true;
        }
        Feature feature = (Feature)jobConfig.getParameters().get(FEATURE_PARAMETER_KEY);
        return this.featureManager.isEnabled(feature);
    }
}

