/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scheduling;

import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.stash.internal.scheduling.ScheduledJobSource;
import com.atlassian.stash.internal.spring.AbstractSmartLifecycle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.OrderComparator;
import org.springframework.stereotype.Component;

@Component
public class ScheduledJobLifecycle
extends AbstractSmartLifecycle {
    private static final Logger log = LoggerFactory.getLogger(ScheduledJobLifecycle.class);
    private final SchedulerService schedulerService;
    private final ImmutableList<ScheduledJobSource> sources;

    @Autowired
    public ScheduledJobLifecycle(SchedulerService schedulerService, List<ScheduledJobSource> sources) {
        sources = Lists.newArrayList(sources);
        OrderComparator.sort((List)sources);
        this.schedulerService = schedulerService;
        this.sources = ImmutableList.copyOf((Collection)sources);
    }

    public int getPhase() {
        return 1001;
    }

    @Override
    public void start() {
        log.debug("Applying {} job sources", (Object)this.sources.size());
        for (ScheduledJobSource source : this.sources) {
            String name = ScheduledJobLifecycle.getName(source);
            try {
                log.debug("Scheduling jobs for {}", (Object)name);
                source.schedule(this.schedulerService);
            }
            catch (SchedulerServiceException e) {
                log.error("Failed to schedule jobs for {}", (Object)name, (Object)e);
            }
        }
        super.start();
    }

    @Override
    public void stop() {
        for (ScheduledJobSource source : this.sources.reverse()) {
            String name = ScheduledJobLifecycle.getName(source);
            try {
                log.debug("Unscheduling jobs for {}", (Object)name);
                source.unschedule(this.schedulerService);
            }
            catch (SchedulerServiceException e) {
                log.error("Failed to unschedule jobs for {}", (Object)name, (Object)e);
            }
        }
        super.stop();
    }

    private static String getName(ScheduledJobSource source) {
        return AopUtils.getTargetClass((Object)source).getSimpleName();
    }
}

