/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scheduling;

import com.atlassian.bitbucket.shutdown.ShutdownHook;
import com.atlassian.bitbucket.shutdown.ShutdownHookStatus;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.core.LifecycleAwareSchedulerService;
import com.atlassian.scheduler.core.RunningJob;
import com.atlassian.stash.internal.spring.AbstractSmartLifecycle;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=ShutdownHook.class)
@Component(value="schedulerLifecycle")
public class SchedulerLifecycle
extends AbstractSmartLifecycle
implements ShutdownHook {
    private static final Logger log = LoggerFactory.getLogger(SchedulerLifecycle.class);
    private static final Function<RunningJob, JobId> TO_JOB_ID = JobRunnerRequest::getJobId;
    private final LifecycleAwareSchedulerService schedulerService;

    @Autowired
    public SchedulerLifecycle(LifecycleAwareSchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    public int getPhase() {
        return 50;
    }

    @Nonnull
    public ShutdownHookStatus getStatus() {
        return this.schedulerService.getLocallyRunningJobs().isEmpty() ? ShutdownHookStatus.IDLE : ShutdownHookStatus.ACTIVE;
    }

    public void shutdownNow() {
        if (this.schedulerService.getState() != LifecycleAwareSchedulerService.State.SHUTDOWN) {
            this.schedulerService.shutdown();
        }
    }

    @Override
    public void start() {
        try {
            this.schedulerService.start();
            super.start();
        }
        catch (SchedulerServiceException e) {
            throw new IllegalStateException("The scheduler could not be started", e);
        }
    }

    public void startShutdown(@Nonnull Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        this.schedulerService.shutdown();
        try {
            this.schedulerService.waitUntilIdle(timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted while waiting for SchedulerService to be idle", e);
        }
    }

    @Override
    public void stop() {
        Collection locallyRunningJobs = this.schedulerService.getLocallyRunningJobs();
        if (!locallyRunningJobs.isEmpty()) {
            log.warn("The following jobs could not be canceled. They will be killed when the JVM terminates: {}", locallyRunningJobs.stream().map(TO_JOB_ID).collect(Collectors.toList()));
        }
        super.stop();
    }
}

