/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scheduling.aspect;

import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.server.ApplicationModeSupplier;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Order(value=5)
@Component
public class ApplicationModeScheduledJobAspect {
    private final ApplicationMode applicationMode;

    @Autowired
    public ApplicationModeScheduledJobAspect(ApplicationModeSupplier applicationModeSupplier) {
        this.applicationMode = applicationModeSupplier.getMode();
    }

    @Pointcut(value="@annotation(com.atlassian.stash.internal.mode.DefaultApplicationMode)")
    public void isDefaultApplicationMode() {
    }

    @Pointcut(value="@annotation(com.atlassian.stash.internal.mode.MirrorApplicationMode)")
    public void isMirrorApplicationMode() {
    }

    @Pointcut(value="execution(* com.atlassian.stash.internal.scheduling.ScheduledJobSource.schedule(com.atlassian.scheduler.SchedulerService))")
    public void isScheduledJobSourceScheduleMethod() {
    }

    @Around(value="isScheduledJobSourceScheduleMethod() && isDefaultApplicationMode()")
    public Object scheduleJobOnlyOnDefaultMode(ProceedingJoinPoint joinPoint) throws Throwable {
        if (this.applicationMode == ApplicationMode.DEFAULT) {
            return joinPoint.proceed();
        }
        return null;
    }

    @Around(value="isScheduledJobSourceScheduleMethod() && isMirrorApplicationMode()")
    public Object scheduleJobOnlyOnMirrorMode(ProceedingJoinPoint joinPoint) throws Throwable {
        if (this.applicationMode == ApplicationMode.MIRROR) {
            return joinPoint.proceed();
        }
        return null;
    }
}

