/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.spring;

import com.atlassian.stash.internal.spring.DefaultTransactionalState;
import com.atlassian.stash.internal.spring.TransactionSynchronizer;
import com.atlassian.stash.internal.spring.TransactionalState;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Component(value="transactionSynchronizer")
public class DefaultTransactionSynchronizer
implements TransactionSynchronizer {
    @Override
    @Nonnull
    public <K, V> TransactionalState<K, V> getTransactionState(@Nonnull Object namespace) {
        return new DefaultTransactionalState(Objects.requireNonNull(namespace, "namespace"));
    }

    @Override
    public boolean isAvailable() {
        return TransactionSynchronizationManager.isActualTransactionActive() && TransactionSynchronizationManager.isSynchronizationActive();
    }

    @Override
    public boolean isReadOnly() {
        return TransactionSynchronizationManager.isCurrentTransactionReadOnly();
    }

    @Override
    public boolean register(@Nonnull TransactionSynchronization synchronization) {
        if (this.isAvailable()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)Objects.requireNonNull(synchronization, "synchronization"));
            return true;
        }
        return false;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        TransactionSynchronizationManager.setCurrentTransactionReadOnly((boolean)readOnly);
    }
}

