/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.spring;

import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.transaction.annotation.SpringTransactionAnnotationParser;
import org.springframework.transaction.interceptor.TransactionAttribute;

public class ExtendedTransactionAnnotationParser
extends SpringTransactionAnnotationParser {
    static final Set<String> EXCEPTIONS = ImmutableSet.of((Object)"com.atlassian.bitbucket.repository.RepositoryOfflineException", (Object)"com.atlassian.bitbucket.mesh.RepositoryInconsistentException");

    @Nonnull
    protected TransactionAttribute parseTransactionAnnotation(@Nonnull AnnotationAttributes attributes) {
        if (ExtendedTransactionAnnotationParser.streamRollbacks(attributes).noneMatch(EXCEPTIONS::contains)) {
            Class[] byClass = attributes.getClassArray("noRollbackFor");
            Object[] byName = attributes.getStringArray("noRollbackForClassName");
            if (ExtendedTransactionAnnotationParser.streamMergedArrays(byClass, (String[])byName).noneMatch(EXCEPTIONS::contains)) {
                byName = byName.length == 0 ? EXCEPTIONS.toArray(new String[0]) : (String[])ArrayUtils.addAll((Object[])byName, (Object[])EXCEPTIONS.toArray(new String[0]));
                attributes.put((Object)"noRollbackForClassName", (Object)byName);
            }
        }
        return super.parseTransactionAnnotation(attributes);
    }

    private static Stream<String> streamMergedArrays(Class<?>[] byClass, String[] byName) {
        return Stream.concat(Stream.of(byName), Stream.of(byClass).map(Class::getName));
    }

    private static Stream<String> streamRollbacks(AnnotationAttributes attributes) {
        return ExtendedTransactionAnnotationParser.streamMergedArrays(attributes.getClassArray("rollbackFor"), attributes.getStringArray("rollbackForClassName"));
    }
}

