/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.spring.env;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class PropertySourceUtils {
    @Nonnull
    public static String formatPropertySourceName(@Nonnull Path file) {
        return "applicationConfig: [" + Objects.requireNonNull(file, "file").toUri().toString() + "]";
    }

    @Nullable
    public static PropertySource<?> getPropertySource(@Nonnull Environment environment, @Nonnull Path file) {
        Objects.requireNonNull(environment, "environment");
        Objects.requireNonNull(file, "file");
        return PropertySourceUtils.getPropertySources(environment).map(propertySources -> propertySources.get(PropertySourceUtils.formatPropertySourceName(file))).orElse(null);
    }

    @Nonnull
    public static PropertySource<?> renamePropertySource(@Nonnull PropertySource<?> propertySource, @Nonnull Path file) {
        return PropertySourceUtils.renamePropertySource(propertySource, PropertySourceUtils.formatPropertySourceName(file));
    }

    @Nonnull
    public static PropertySource<?> renamePropertySource(@Nonnull PropertySource<?> propertySource, @Nonnull String name) {
        Objects.requireNonNull(propertySource, "propertySource");
        Objects.requireNonNull(name, "name");
        return propertySource instanceof EnumerablePropertySource ? new DelegatingEnumerablePropertySource(name, (EnumerablePropertySource)propertySource) : new DelegatingPropertySource(name, propertySource);
    }

    public static void withPropertySource(@Nonnull Environment environment, @Nonnull Path file, @Nonnull BiConsumer<MutablePropertySources, PropertySource<?>> consumer) {
        Objects.requireNonNull(environment, "environment");
        Objects.requireNonNull(file, "file");
        Objects.requireNonNull(consumer, "consumer");
        PropertySourceUtils.getPropertySources(environment).ifPresent(propertySources -> {
            PropertySource propertySource = propertySources.get(PropertySourceUtils.formatPropertySourceName(file));
            if (propertySource != null) {
                consumer.accept((MutablePropertySources)propertySources, (PropertySource<?>)propertySource);
            }
        });
    }

    private static Optional<MutablePropertySources> getPropertySources(Environment environment) {
        if (environment instanceof ConfigurableEnvironment) {
            return Optional.of(((ConfigurableEnvironment)environment).getPropertySources());
        }
        return Optional.empty();
    }

    private static class DelegatingEnumerablePropertySource
    extends EnumerablePropertySource<EnumerablePropertySource<?>> {
        public DelegatingEnumerablePropertySource(String name, EnumerablePropertySource<?> source) {
            super(name, source);
        }

        public boolean containsProperty(String name) {
            return ((EnumerablePropertySource)this.source).containsProperty(name);
        }

        public String[] getPropertyNames() {
            return ((EnumerablePropertySource)this.source).getPropertyNames();
        }

        public Object getProperty(String name) {
            return ((EnumerablePropertySource)this.source).getProperty(name);
        }
    }

    private static class DelegatingPropertySource
    extends PropertySource<PropertySource<?>> {
        public DelegatingPropertySource(String name, PropertySource<?> source) {
            super(name, source);
        }

        public boolean containsProperty(String name) {
            return ((PropertySource)this.source).containsProperty(name);
        }

        public Object getProperty(String name) {
            return ((PropertySource)this.source).getProperty(name);
        }
    }
}

