/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.utils;

import java.util.function.Supplier;

public class ClassLoaderUtils {
    private ClassLoaderUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T runWithClassloader(ClassLoader classloader, Supplier<T> action) {
        Thread currentThread = Thread.currentThread();
        ClassLoader original = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(classloader);
            T t = action.get();
            return t;
        }
        finally {
            currentThread.setContextClassLoader(original);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T runWithClassloaderThrowable(ClassLoader classloader, ThrowingSupplier<T> action) throws Throwable {
        Thread currentThread = Thread.currentThread();
        ClassLoader original = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(classloader);
            T t = action.get();
            return t;
        }
        finally {
            currentThread.setContextClassLoader(original);
        }
    }

    @FunctionalInterface
    public static interface ThrowingSupplier<T> {
        public T get() throws Throwable;
    }
}

