/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.utils;

import com.google.common.primitives.Ints;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.InvocationTargetException;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.janino.ExpressionEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExpressionUtils {
    private static final Pattern FORMULA_PATTERN = Pattern.compile("[\\d+\\-*/()\\s.]+");
    private static final Logger log = LoggerFactory.getLogger(ExpressionUtils.class);

    @Nonnull
    public static OptionalDouble parseExpressionAsDouble(@Nullable String expression) {
        return ExpressionUtils.parseExpression(expression, OptionalDouble::of, OptionalDouble::empty);
    }

    @Nonnull
    public static OptionalInt parseExpressionAsInt(@Nullable String expression) {
        OptionalLong longValue = ExpressionUtils.parseExpressionAsLong(expression);
        if (longValue.isPresent()) {
            return OptionalInt.of(Ints.saturatedCast((long)longValue.getAsLong()));
        }
        return OptionalInt.empty();
    }

    @Nonnull
    public static OptionalLong parseExpressionAsLong(@Nullable String expression) {
        return ExpressionUtils.parseExpression(expression, value -> OptionalLong.of(Math.round(value)), OptionalLong::empty);
    }

    @Nonnull
    private static <OV> OV parseExpression(@Nullable String expression, Function<Double, OV> toOptional, Supplier<OV> emptyOptional) {
        if (expression != null && FORMULA_PATTERN.matcher(expression = expression.toLowerCase().replace("cpu", Integer.toString(Runtime.getRuntime().availableProcessors()))).matches()) {
            try {
                ExpressionEvaluator evaluator = new ExpressionEvaluator(expression, Double.TYPE, new String[0], new Class[0]);
                return toOptional.apply((Double)evaluator.evaluate(new Object[0]));
            }
            catch (CompileException e) {
                log.debug("Error while parsing expression " + expression, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                log.debug("Error while evaluating expression " + expression, (Throwable)e);
            }
        }
        return emptyOptional.get();
    }
}

